package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OutlierDetection {

  def apply(
    interval: software.amazon.awscdk.Duration,
    baseEjectionDuration: software.amazon.awscdk.Duration,
    maxEjectionPercent: Number,
    maxServerErrors: Number
  ): software.amazon.awscdk.services.appmesh.OutlierDetection =
    (new software.amazon.awscdk.services.appmesh.OutlierDetection.Builder)
      .interval(interval)
      .baseEjectionDuration(baseEjectionDuration)
      .maxEjectionPercent(maxEjectionPercent)
      .maxServerErrors(maxServerErrors)
      .build()
}
