package io.burkard.cdk.services.appmesh

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GrpcGatewayRouteMatch {

  def apply(
    hostname: Option[software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch] = None,
    serviceName: Option[String] = None,
    rewriteRequestHostname: Option[Boolean] = None,
    metadata: Option[List[_ <: software.amazon.awscdk.services.appmesh.HeaderMatch]] = None
  ): software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch =
    (new software.amazon.awscdk.services.appmesh.GrpcGatewayRouteMatch.Builder)
      .hostname(hostname.orNull)
      .serviceName(serviceName.orNull)
      .rewriteRequestHostname(rewriteRequestHostname.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .metadata(metadata.map(_.asJava).orNull)
      .build()
}
