/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.maven.openapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="openapi", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class OpenApiMojo
extends AbstractMojo {
    @Parameter(name="source")
    String source;
    @Parameter(name="destination")
    String destination;
    @Parameter(property="project.build.outputDirectory")
    String buildOut;
    @Parameter(property="project.build.resources[0].directory")
    String buildResourceDir;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() {
        File sourceFile;
        if (this.source == null) {
            this.source = "meta/openapi.json";
        }
        if (this.destination == null) {
            this.destination = "public/openapi.json";
        }
        if (!(sourceFile = new File(new File(this.buildOut), this.source)).exists()) {
            this.getLog().warn((CharSequence)("openapi file not found at  " + sourceFile));
            return;
        }
        File srcMainRes = new File(this.buildResourceDir);
        if (this.destination != null) {
            File destFile = new File(srcMainRes, this.destination);
            File destDir = destFile.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs()) {
                this.getLog().error((CharSequence)("Failed to make directory " + destDir));
            } else {
                try {
                    this.moveToMainResources(sourceFile, destFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Failed to copy openapi file", (Throwable)e);
                }
            }
        }
    }

    private void moveToMainResources(File sourceFile, File destFile) throws IOException {
        Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.getLog().info((CharSequence)("copied openapi file to " + destFile));
        if (!sourceFile.delete()) {
            this.getLog().warn((CharSequence)("Failed to delete the temporary openapi file " + sourceFile));
        } else {
            this.deleteParentIfEmpty(sourceFile);
        }
    }

    private void deleteParentIfEmpty(File sourceFile) {
        File meta = sourceFile.getParentFile();
        String[] list = meta.list();
        if (list != null && list.length == 0 && meta.delete()) {
            this.getLog().debug((CharSequence)"deleted empty meta directory");
        }
    }
}

