/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.spring.aspect;

import io.avaje.validation.ValidMethod;
import io.avaje.validation.Validator;
import io.avaje.validation.adapter.MethodAdapterProvider;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.spring.aspect.ParamInterceptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class SpringAOPMethodValidator {
    private final Map<Method, ParamInterceptor> interceptorMap = new HashMap<Method, ParamInterceptor>();

    public SpringAOPMethodValidator(Validator validator, List<MethodAdapterProvider> providers) throws Exception {
        ValidationContext ctx = validator.context();
        for (MethodAdapterProvider provider : providers) {
            Method method = provider.method();
            ValidMethod validMethod = method.getAnnotation(ValidMethod.class);
            String localeStr = validMethod.locale();
            Locale locale = localeStr.isBlank() ? null : Locale.forLanguageTag(localeStr);
            List paramValidationAdapter = provider.paramAdapters(ctx);
            ValidationAdapter returnValidationAdapter = provider.returnAdapter(ctx);
            ValidationAdapter crossParamAdapter = provider.crossParamAdapter(ctx);
            this.interceptorMap.put(method, new ParamInterceptor(locale, validMethod.throwOnParamFailure(), ctx, paramValidationAdapter, (ValidationAdapter<Object>)returnValidationAdapter, (ValidationAdapter<Object[]>)crossParamAdapter));
        }
    }

    @Around(value="@annotation(io.avaje.validation.ValidMethod)")
    public void interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        ParamInterceptor methodValidator = this.interceptorMap.get(signature.getMethod());
        methodValidator.invoke(joinPoint);
    }
}

