/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.spring.validator;

import io.avaje.validation.Validator;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AvajeValidatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Validator validator(@Value(value="${validation.failFast:false}") boolean failFast, @Value(value="${validation.resourcebundle.names:#{null}}") Optional<String> resourceBundleNames, @Value(value="${validation.locale.default:#{null}}") Optional<String> defaultLocal, @Value(value="${validation.locale.addedLocales:#{null}}") Optional<String> addedLocales, @Value(value="${validation.temporal.tolerance.value:#{null}}") Optional<String> temporalTolerance, @Value(value="${validation.temporal.tolerance.chronoUnit:MILLIS}") ChronoUnit chronoUnit) {
        Validator.Builder validator = Validator.builder().failFast(failFast);
        resourceBundleNames.map(s -> s.split(",")).ifPresent(arg_0 -> ((Validator.Builder)validator).addResourceBundles(arg_0));
        defaultLocal.map(Locale::forLanguageTag).ifPresent(arg_0 -> ((Validator.Builder)validator).setDefaultLocale(arg_0));
        Stream<Locale> stream = addedLocales.stream().flatMap(s -> Arrays.stream(s.split(","))).map(Locale::forLanguageTag);
        Validator.Builder builder = validator;
        Objects.requireNonNull(builder);
        Validator.Builder builder2 = builder;
        stream.forEach(xva$0 -> builder2.addLocales(new Locale[]{xva$0}));
        temporalTolerance.map(Long::valueOf).ifPresent(duration -> {
            ChronoUnit unit = chronoUnit;
            validator.temporalTolerance(Duration.of(duration, unit));
        });
        return validator.build();
    }
}

