/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.spring.aspect;

import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import java.util.List;
import java.util.Locale;
import org.aspectj.lang.ProceedingJoinPoint;

final class ParamInterceptor {
    private final Locale locale;
    private final boolean throwOnParamFailure;
    private final List<ValidationAdapter<Object>> paramValidationAdapter;
    private final ValidationAdapter<Object> returnValidationAdapter;
    private final ValidationContext ctx;
    private final ValidationAdapter<Object[]> crossParamAdapter;

    public ParamInterceptor(Locale locale, boolean throwOnParamFailure, ValidationContext ctx, List<ValidationAdapter<Object>> paramValidationAdapter, ValidationAdapter<Object> returnValidationAdapter, ValidationAdapter<Object[]> crossParamAdapter) {
        this.locale = locale;
        this.throwOnParamFailure = throwOnParamFailure;
        this.paramValidationAdapter = paramValidationAdapter;
        this.returnValidationAdapter = returnValidationAdapter;
        this.ctx = ctx;
        this.crossParamAdapter = crossParamAdapter;
    }

    public void invoke(ProceedingJoinPoint invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        ValidationRequest req = this.ctx.request(this.locale, List.of());
        int i = 0;
        for (ValidationAdapter<Object> adapter : this.paramValidationAdapter) {
            Object object = args[i];
            adapter.validate(object, req);
            ++i;
        }
        this.crossParamAdapter.validate((Object)args, req);
        if (this.throwOnParamFailure) {
            req.throwWithViolations();
        }
        this.returnValidationAdapter.validate(invocation.proceed(), req);
        req.throwWithViolations();
    }
}

