/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.inject.aspect;

import io.avaje.inject.PostConstruct;
import io.avaje.inject.aop.AspectProvider;
import io.avaje.inject.aop.MethodInterceptor;
import io.avaje.validation.ValidMethod;
import io.avaje.validation.adapter.MethodAdapterProvider;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.inject.aspect.ParamInterceptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

public final class AOPMethodValidator
implements AspectProvider<ValidMethod> {
    private final List<BiConsumer<ValidationContext, Map<Method, MethodAdapterProvider>>> consumers = new ArrayList<BiConsumer<ValidationContext, Map<Method, MethodAdapterProvider>>>();

    @PostConstruct
    public void post(ValidationContext ctx, Map<Method, MethodAdapterProvider> map) {
        this.consumers.forEach(c -> c.accept(ctx, map));
        this.consumers.clear();
    }

    public MethodInterceptor interceptor(Method method, ValidMethod aspectAnnotation) {
        String localeStr = aspectAnnotation.locale();
        Locale locale = localeStr.isBlank() ? null : Locale.forLanguageTag(localeStr);
        ParamInterceptor interceptor = new ParamInterceptor(locale, method, aspectAnnotation.throwOnParamFailure());
        this.consumers.add(interceptor::postConstruct);
        return interceptor;
    }
}

