/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.http;

import io.avaje.http.api.ValidationException;
import io.avaje.inject.BeanScope;
import io.avaje.inject.PostConstruct;
import io.avaje.validation.ConstraintViolation;
import io.avaje.validation.ConstraintViolationException;
import io.avaje.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class BeanValidator
implements io.avaje.http.api.Validator {
    private Validator validator;
    private final Collection<Locale> locales;

    public BeanValidator(Collection<Locale> locales) {
        this.locales = locales;
    }

    public void validate(Object bean, String acceptLanguage, Class<?> ... groups) throws ValidationException {
        Locale language = this.resolveLocale(acceptLanguage, this.locales);
        try {
            this.validator.validate(bean, language, (Class[])groups);
        }
        catch (ConstraintViolationException e) {
            this.throwExceptionWith(e);
        }
    }

    @PostConstruct
    public void setValidator(BeanScope scope) {
        this.validator = (Validator)scope.get(Validator.class);
    }

    private void throwExceptionWith(ConstraintViolationException cause) {
        ArrayList<ValidationException.Violation> errors = new ArrayList<ValidationException.Violation>();
        for (ConstraintViolation violation : cause.violations()) {
            String path = violation.path();
            String field = violation.field();
            String message = violation.message();
            errors.add(new ValidationException.Violation(path, field, message));
        }
        throw new ValidationException(422, cause.getMessage(), (Throwable)cause, errors);
    }
}

