/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.ModuleInfoReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;

final class ModuleReader {
    private final Map<String, Set<String>> missingServicesMap = new HashMap<String, Set<String>>();
    private boolean staticWarning;
    private boolean coreWarning;

    ModuleReader(Map<String, Set<String>> services) {
        services.forEach(this::add);
    }

    private void add(String k, Set<String> v) {
        this.missingServicesMap.put(ModuleReader.replace$(k), v.stream().map(ModuleReader::replace$).collect(Collectors.toSet()));
    }

    private static String replace$(String k) {
        return k.replace('$', '.');
    }

    void read(BufferedReader reader, ModuleElement element) throws IOException {
        ModuleInfoReader module = new ModuleInfoReader(element, reader);
        for (ModuleInfoReader.Requires require : module.requires()) {
            ModuleElement dep = require.getDependency();
            if (!require.isStatic() && dep.getQualifiedName().contentEquals("io.avaje.spi")) {
                this.staticWarning = true;
            }
            if (dep.getQualifiedName().contentEquals("io.avaje.spi.core")) {
                this.coreWarning = true;
            }
            if (!this.staticWarning || !this.coreWarning) continue;
            break;
        }
        module.provides().forEach(p -> {
            String contract = ModuleReader.replace$(p.service());
            if (!this.missingServicesMap.containsKey(contract)) {
                return;
            }
            List<String> impls = p.implementations();
            Set<String> missing = this.missingServicesMap.get(contract);
            if (missing.size() != impls.size()) {
                return;
            }
            impls.stream().map(ModuleReader::replace$).forEach(missing::remove);
        });
    }

    boolean staticWarning() {
        return this.staticWarning;
    }

    boolean coreWarning() {
        return this.coreWarning;
    }

    Map<String, Set<String>> missing() {
        return this.missingServicesMap;
    }
}

