/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.ServiceProviderPrism;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.avaje.spi.ServiceProvider"})
public class ServiceProcessor
extends AbstractProcessor {
    private final Map<String, Set<String>> services = new ConcurrentHashMap<String, Set<String>>();
    private Elements elements;
    private Messager messager;
    private Types types;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elements = env.getElementUtils();
        this.messager = env.getMessager();
        this.types = env.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment roundEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(this.element("io.avaje.spi.ServiceProvider"));
        for (TypeElement type : ElementFilter.typesIn(annotated)) {
            this.validate(type);
            List<TypeElement> contracts = this.getServiceInterfaces(type);
            if (contracts.isEmpty()) {
                this.logError(type, "Service Providers must implement an SPI interface", new Object[0]);
            }
            for (TypeElement contract : contracts) {
                String cn = this.elements.getBinaryName(contract).toString();
                Set v = this.services.computeIfAbsent(cn, k -> new TreeSet());
                v.add(this.elements.getBinaryName(type).toString());
            }
        }
        if (roundEnv.processingOver()) {
            this.write();
        }
        return false;
    }

    private void validate(TypeElement type) {
        boolean noPublicConstructor;
        Set<Modifier> mods = type.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC) || type.getEnclosingElement().getKind() == ElementKind.CLASS && !mods.contains((Object)Modifier.STATIC)) {
            this.logError(type, "A Service Provider must be a public class or a public static nested class", new Object[0]);
        }
        if (noPublicConstructor = ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(e -> e.getParameters().isEmpty()).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).findAny().isEmpty()) {
            this.logError(type, "A Service Provider must have a public no-args constructor", new Object[0]);
        }
    }

    private void write() {
        FileObject file2;
        String contract;
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry<String, Set<String>> e : this.services.entrySet()) {
            contract = e.getKey();
            try {
                String line;
                file2 = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract);
                BufferedReader buffer = new BufferedReader(new InputStreamReader(file2.openInputStream(), StandardCharsets.UTF_8));
                while ((line = buffer.readLine()) != null) {
                    e.getValue().add(line);
                }
                buffer.close();
            }
            catch (FileNotFoundException | NoSuchFileException file2) {
            }
            catch (IOException x) {
                this.logError("Failed to load existing service definition file. SPI: " + contract + " exception: " + String.valueOf(x), new Object[0]);
            }
        }
        for (Map.Entry<String, Set<String>> e : this.services.entrySet()) {
            try {
                contract = e.getKey();
                this.logDebug("Writing META-INF/services/%s", contract);
                file2 = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract, new Element[0]);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(file2.openOutputStream(), StandardCharsets.UTF_8));
                for (String value : e.getValue()) {
                    pw.println(value);
                }
                pw.close();
            }
            catch (IOException x) {
                this.logError("Failed to write service definition files: %s", x);
            }
        }
    }

    private List<TypeElement> getServiceInterfaces(TypeElement type) {
        boolean hasInterfaces;
        ArrayList<TypeElement> typeElementList = new ArrayList<TypeElement>();
        List<TypeMirror> spis = ServiceProviderPrism.getInstanceOn(type).value();
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        TypeMirror baseClass = type.getSuperclass();
        boolean hasBaseClass = type.getSuperclass().getKind() != TypeKind.NONE && !this.isObject(type.getSuperclass());
        boolean bl = hasInterfaces = !interfaces.isEmpty();
        if (spis.isEmpty()) {
            if (hasBaseClass ^ hasInterfaces) {
                if (hasBaseClass) {
                    typeElementList.add(this.asElement(type.getSuperclass()));
                } else {
                    typeElementList.add(this.asElement(type.getInterfaces().get(0)));
                }
            } else {
                this.logError(type, "SPI type was not specified, and could not be inferred.", new Object[0]);
            }
            return typeElementList;
        }
        for (TypeMirror spiMirror : spis) {
            if (!hasInterfaces && !hasBaseClass || !this.isAssignable2Interface(type, spiMirror)) {
                this.logError(type, "Service Provider does not extend %s", spiMirror);
                continue;
            }
            if (spiMirror instanceof DeclaredType) {
                typeElementList.add(this.asElement(spiMirror));
                continue;
            }
            this.logError(type, "Invalid type specified as the SPI", new Object[0]);
        }
        return typeElementList;
    }

    private boolean isObject(TypeMirror t) {
        if (t instanceof DeclaredType) {
            return "java.lang.Object".equals(this.asElement(t).getQualifiedName().toString());
        }
        return false;
    }

    private TypeElement element(String rawType) {
        return this.elements.getTypeElement(rawType);
    }

    private TypeElement asElement(TypeMirror returnType) {
        return (TypeElement)this.types.asElement(returnType);
    }

    private void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    private void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    private void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    private boolean isAssignable2Interface(Element type, TypeMirror superType) {
        return Optional.ofNullable(type).stream().flatMap(this::superTypes).anyMatch(superType.toString()::equals);
    }

    private Stream<String> superTypes(Element element) {
        return this.types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)this.types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(this.superTypes((Element)e), Stream.of(e))).map(Object::toString);
    }
}

