/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

class RepeatablePrism {
    public static final String PRISM_TYPE = "java.lang.annotation.Repeatable";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private final boolean valid = true;

    static boolean isPresent(Element element) {
        return RepeatablePrism.getInstanceOn(element) != null;
    }

    static RepeatablePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = RepeatablePrism.getMirror(PRISM_TYPE, element);
        if (mirror == null) {
            return null;
        }
        return RepeatablePrism.getInstance(mirror);
    }

    static Optional<RepeatablePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = RepeatablePrism.getMirror(PRISM_TYPE, element);
        if (mirror == null) {
            return Optional.empty();
        }
        return RepeatablePrism.getOptional(mirror);
    }

    static RepeatablePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new RepeatablePrism(mirror);
    }

    static Optional<RepeatablePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new RepeatablePrism(mirror));
    }

    private RepeatablePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = true;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    static class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

