/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    public static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
    }

    static void logError(Element e, String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    static void logError(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    static void logWarn(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    static void logDebug(String msg, Object ... args) {
        ProcessingContext.CTX.get().messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    static JavaFileObject createWriter(String cls) throws IOException {
        return ProcessingContext.CTX.get().filer.createSourceFile(cls, new Element[0]);
    }

    static TypeElement element(String rawType) {
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(rawType);
    }

    static Types types() {
        return ProcessingContext.CTX.get().typeUtils;
    }

    static TypeElement elementMaybe(String rawType) {
        if (rawType == null) {
            return null;
        }
        return ProcessingContext.CTX.get().elementUtils.getTypeElement(rawType);
    }

    static Element asElement(TypeMirror returnType) {
        return ProcessingContext.CTX.get().typeUtils.asElement(returnType);
    }

    public static void clear() {
        CTX.remove();
    }

    static final class Ctx {
        private final Messager messager;
        private final Filer filer;
        private final Elements elementUtils;
        private final Types typeUtils;

        public Ctx(ProcessingEnvironment processingEnv) {
            this.messager = processingEnv.getMessager();
            this.filer = processingEnv.getFiler();
            this.elementUtils = processingEnv.getElementUtils();
            this.typeUtils = processingEnv.getTypeUtils();
        }
    }
}

