/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import java.io.PrintWriter;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

class PrismWriter {
    String name;
    String mirrorType;
    String prismType;
    boolean arrayed;
    ExecutableElement m;
    String access;
    String m2pFormat = "undefinedConverter(%s)";

    PrismWriter(ExecutableElement m, boolean arrayed, String access) {
        this.m = m;
        this.arrayed = arrayed;
        this.access = access;
        this.name = m.getSimpleName().toString();
    }

    public void setPrismType(String prismType) {
        this.prismType = prismType;
    }

    public void setMirrorType(String mirrorType) {
        this.mirrorType = mirrorType;
    }

    void writeField(String indent, PrintWriter out) {
        out.format("%s  /** store prism value of %s */\n", indent, this.name);
        if (this.arrayed) {
            out.format("%s  private final List<%s> _%s;\n\n", indent, this.prismType, this.name);
        } else {
            out.format("%s  private final %s _%s;\n\n", indent, this.prismType, this.name);
        }
    }

    String mirror2prism(String expr) {
        return String.format(this.m2pFormat, expr);
    }

    public void setM2pFormat(String m2pFormat) {
        this.m2pFormat = m2pFormat;
    }

    void writeInitializer(String indent, PrintWriter out) {
        if (this.arrayed) {
            if (this.mirrorType.equals(this.prismType)) {
                out.format("%s    _%s = getArrayValues(\"%s\", %s.class);\n", indent, this.name, this.name, this.prismType);
            } else {
                out.format("%s    List<%s> %sMirrors = getArrayValues(\"%s\", %s.class);\n", indent, this.mirrorType, this.name, this.name, this.mirrorType);
                out.format("%s     _%s = new ArrayList<%s>(%sMirrors.size());\n", indent, this.name, this.prismType, this.name);
                out.format("%s    for(%s %sMirror : %sMirrors) {\n", indent, this.mirrorType, this.name, this.name);
                out.format("%s        _%s.add(%s);\n", indent, this.name, this.mirror2prism(this.name + "Mirror"));
                out.format("%s    }\n", indent);
            }
        } else if (this.mirrorType.equals(this.prismType)) {
            out.format("%s    _%s = getValue(\"%s\", %s.class);\n", indent, this.name, this.name, this.prismType);
        } else {
            out.format("%s    %s %sMirror = getValue(\"%s\", %s.class);\n", indent, this.mirrorType, this.name, this.name, this.mirrorType);
            out.format("%s    valid = valid && %sMirror != null;\n", indent, this.name);
            out.format("%s    _%s = %sMirror == null ? null : %s;\n", indent, this.name, this.name, this.mirror2prism(this.name + "Mirror"));
        }
    }

    void writeMethod(String indent, PrintWriter out) {
        if (this.arrayed) {
            out.format("%s  /** \n", indent);
            out.format("%s   * Returns a List&lt;%s&gt; representing the value of the {@code %s} member of the Annotation.\n", indent, this.prismType, this.m);
            out.format("%s   * @see %s#%s()\n", indent, ((TypeElement)this.m.getEnclosingElement()).getQualifiedName(), this.name);
            out.format("%s   */ \n", indent);
            out.format("%s  %sList<%s> %s() { return _%s; }\n\n", indent, this.access, this.prismType, this.name, this.name);
        } else {
            out.format("%s  /** \n", indent);
            out.format("%s   * Returns a %s representing the value of the {@code %s %s} member of the Annotation.\n", indent, this.prismType, this.m.getReturnType(), this.m);
            out.format("%s   * @see %s#%s()\n", indent, ((TypeElement)this.m.getEnclosingElement()).getQualifiedName(), this.name);
            out.format("%s   */ \n", indent);
            out.format("%s  %s%s %s() { return _%s; }\n\n", indent, this.access, this.prismType, this.name, this.name);
        }
    }
}

