/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import io.avaje.prism.internal.FactoryMethodWriter;
import io.avaje.prism.internal.GenerateContext;
import io.avaje.prism.internal.GeneratePrismPrism;
import io.avaje.prism.internal.GeneratePrismsPrism;
import io.avaje.prism.internal.PrismWriter;
import io.avaje.prism.internal.ProcessingContext;
import io.avaje.prism.internal.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.avaje.prism.GeneratePrism", "io.avaje.prism.GeneratePrisms"})
public final class PrismGenerator
extends AbstractProcessor {
    private final Map<String, TypeMirror> generated = new HashMap<String, TypeMirror>();
    private final Deque<DeclaredType> inners = new ArrayDeque<DeclaredType>();
    private final Set<DeclaredType> seenInners = new HashSet<DeclaredType>();
    private Elements elements;
    private Types types;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        ProcessingContext.init(env);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        Object ann;
        if (renv.processingOver()) {
            ProcessingContext.clear();
            return true;
        }
        TypeElement a = this.elements.getTypeElement("io.avaje.prism.GeneratePrism");
        TypeElement as = this.elements.getTypeElement("io.avaje.prism.GeneratePrisms");
        for (Element element : renv.getElementsAnnotatedWith(a)) {
            ann = GeneratePrismPrism.getInstanceOn(element);
            if (!((GeneratePrismPrism)ann).isValid) continue;
            this.generateIfNew((GeneratePrismPrism)ann, element, Map.of());
        }
        for (Element element : renv.getElementsAnnotatedWith(as)) {
            ann = GeneratePrismsPrism.getInstanceOn(element);
            if (!((GeneratePrismsPrism)ann).isValid) continue;
            HashMap<DeclaredType, String> otherPrisms = new HashMap<DeclaredType, String>();
            for (GeneratePrismPrism inner : ((GeneratePrismsPrism)ann).value()) {
                this.getPrismName(inner);
                otherPrisms.put((DeclaredType)inner.value(), this.getPrismName(inner));
            }
            for (GeneratePrismPrism inner : ((GeneratePrismsPrism)ann).value()) {
                this.generateIfNew(inner, element, otherPrisms);
            }
        }
        return false;
    }

    private String getPrismName(GeneratePrismPrism ann) {
        Object name = ann.name();
        if ("".equals(name)) {
            name = ((DeclaredType)ann.value()).asElement().getSimpleName() + "Prism";
        }
        return name;
    }

    private void generateIfNew(GeneratePrismPrism ann, Element e, Map<DeclaredType, String> otherPrisms) {
        String prismFqn;
        String name = this.getPrismName(ann);
        String packageName = this.getPackageName(e);
        if ("unnamed package".equals(packageName)) {
            packageName = "";
        }
        String string = prismFqn = "".equals(packageName) ? name : packageName + "." + name;
        if (this.generated.containsKey(prismFqn)) {
            if (this.generated.get(prismFqn).equals(ann.value())) {
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s has already been generated for %s", prismFqn, this.generated.get(prismFqn)), e, ann.mirror);
            return;
        }
        this.generatePrism(name, packageName, (DeclaredType)ann.value(), ann.publicAccess() != false ? "public " : "", otherPrisms);
        this.generated.put(prismFqn, ann.value());
    }

    private String getPackageName(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e).getQualifiedName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePrism(String name, String packageName, DeclaredType typeMirror, String access, Map<DeclaredType, String> otherPrisms) {
        this.inners.clear();
        this.seenInners.clear();
        String prismFqn = "".equals(packageName) ? name : packageName + "." + name;
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.processingEnv.getFiler().createSourceFile(prismFqn, new Element[0]).openWriter());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        try {
            if (!"".equals(packageName)) {
                out.format("package %s;\n\n", packageName);
            }
            boolean isMeta = Util.isMeta(typeMirror);
            boolean isRepeatable = Util.isRepeatable(typeMirror);
            if (isRepeatable || isMeta) {
                out.format("import static java.util.stream.Collectors.*;\n", new Object[0]);
                out.format("import java.util.stream.Stream;\n", new Object[0]);
            }
            if (isMeta) {
                out.format("import javax.lang.model.type.DeclaredType;\n", new Object[0]);
                out.format("import java.util.Set;\n", new Object[0]);
                out.format("import java.util.HashSet;\n", new Object[0]);
            }
            out.format("import java.util.ArrayList;\n", new Object[0]);
            out.format("import java.util.List;\n", new Object[0]);
            out.format("import java.util.Optional;\n", new Object[0]);
            out.format("import java.util.Map;\n", new Object[0]);
            out.format("import javax.lang.model.element.AnnotationMirror;\n", new Object[0]);
            out.format("import javax.lang.model.element.Element;\n", new Object[0]);
            out.format("import javax.lang.model.element.VariableElement;\n", new Object[0]);
            out.format("import javax.lang.model.element.AnnotationValue;\n", new Object[0]);
            out.format("import javax.lang.model.type.TypeMirror;\n", new Object[0]);
            out.format("import java.util.HashMap;\n", new Object[0]);
            out.format("import javax.lang.model.element.ExecutableElement;\n", new Object[0]);
            out.format("import javax.lang.model.element.TypeElement;\n", new Object[0]);
            out.format("import javax.lang.model.util.ElementFilter;\n\n", new Object[0]);
            String annName = ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
            out.format("/** A Prism representing an {@code @%s} annotation. */ \n", annName);
            out.format("%sfinal class %s {\n", access, name);
            this.generateClassBody(new GenerateContext("", out, name, name, typeMirror, access), otherPrisms);
            while (this.inners.peek() != null) {
                DeclaredType next = this.inners.remove();
                String innerName = next.asElement().getSimpleName().toString() + "Prism";
                ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
                out.format("\n  /** %s inner prism. */\n", innerName);
                out.format("  %sstatic class %s {\n", access, innerName);
                this.generateClassBody(new GenerateContext("  ", out, name, innerName, next, access), otherPrisms);
                out.format("  }\n", new Object[0]);
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(typeMirror.asElement().getEnclosedElements());
            Stream<TypeKind> methodsKinds = methods.stream().map(ExecutableElement::getReturnType).map(TypeMirror::getKind);
            boolean writeArrayValue = methodsKinds.anyMatch(TypeKind.ARRAY::equals);
            boolean writeValue = !methods.isEmpty();
            this.generateStaticMembers(out, isRepeatable || isMeta, writeValue, writeArrayValue);
            out.format("}\n", new Object[0]);
        }
        finally {
            out.close();
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Generated prism %s for @%s", prismFqn, typeMirror));
    }

    private void generateClassBody(GenerateContext ctx, Map<DeclaredType, String> otherPrisms) {
        String indent = ctx.indent();
        PrintWriter out = ctx.out();
        String name = ctx.name();
        String outerName = ctx.outerName();
        DeclaredType typeMirror = ctx.typeMirror();
        String access = ctx.access();
        boolean writeArrayValue = false;
        boolean writeValue = false;
        ArrayList<PrismWriter> writers = new ArrayList<PrismWriter>();
        for (ExecutableElement m : ElementFilter.methodsIn(typeMirror.asElement().getEnclosedElements())) {
            if (m.getReturnType().getKind() == TypeKind.ARRAY) {
                writeArrayValue = true;
            }
            writeValue = true;
            writers.add(this.getWriter(m, access, otherPrisms));
        }
        for (PrismWriter w : writers) {
            w.writeField(indent, out);
        }
        String annName = ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
        ctx.setAnnName(annName);
        out.format("%s  public static final String PRISM_TYPE = \"%s\";\n\n", indent, ((TypeElement)typeMirror.asElement()).getQualifiedName());
        out.format("%s  /**\n", indent);
        out.format("%s   * An instance of the Values inner class whose\n", indent);
        out.format("%s   * methods return the AnnotationValues used to build this prism. \n", indent);
        out.format("%s   * Primarily intended to support using Messager.\n", indent);
        out.format("%s   */\n", indent);
        out.format("%s  %sfinal Values values;\n\n", indent, access);
        boolean inner = !"".equals(indent);
        new FactoryMethodWriter(ctx, inner).write();
        out.format("%s  private %s(AnnotationMirror mirror) {\n", indent, name);
        out.format("%s    for (final ExecutableElement key : mirror.getElementValues().keySet()) {\n", indent);
        out.format("%s      memberValues.put(key.getSimpleName().toString(), mirror.getElementValues().get(key));\n", indent);
        out.format("%s    }\n", indent);
        out.format("%s    for (final ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {\n", indent);
        out.format("%s      defaults.put(member.getSimpleName().toString(), member.getDefaultValue());\n", indent);
        out.format("%s    }\n", indent);
        for (PrismWriter w : writers) {
            w.writeInitializer(indent, out);
        }
        out.format("%s    this.values = new Values(memberValues);\n", indent);
        out.format("%s    this.mirror = mirror;\n", indent);
        out.format("%s    this.isValid = valid;\n", indent);
        out.format("%s  }\n\n", indent);
        for (PrismWriter w : writers) {
            w.writeMethod(indent, out);
        }
        out.format("%s  /**\n", indent);
        out.format("%s   * Determine whether the underlying AnnotationMirror has no errors.\n", indent);
        out.format("%s   * True if the underlying AnnotationMirror has no errors.\n", indent);
        out.format("%s   * When true is returned, none of the methods will return null.\n", indent);
        out.format("%s   * When false is returned, a least one member will either return null, or another\n", indent);
        out.format("%s   * prism that is not valid.\n", indent);
        out.format("%s   */\n", indent);
        out.format("%s   %sfinal boolean isValid;\n", indent, access);
        out.format("%s    \n", indent);
        out.format("%s  /**\n", indent);
        out.format("%s   * The underlying AnnotationMirror of the annotation\n", indent);
        out.format("%s   * represented by this Prism. \n", indent);
        out.format("%s   * Primarily intended to support using Messager.\n", indent);
        out.format("%s   */\n", indent);
        out.format("%s   %sfinal AnnotationMirror mirror;\n", indent, access);
        out.format("%s  /**\n", indent);
        out.format("%s   * A class whose members corespond to those of %s\n", indent, annName);
        out.format("%s   * but which each return the AnnotationValue corresponding to\n", indent);
        out.format("%s   * that member in the model of the annotations. Returns null for\n", indent);
        out.format("%s   * defaulted members. Used for Messager, so default values are not useful.\n", indent);
        out.format("%s   */\n", indent);
        out.format("%s  %sstatic final class Values {\n", indent, access);
        out.format("%s    private final Map<String, AnnotationValue> values;\n\n", indent);
        out.format("%s    private Values(Map<String, AnnotationValue> values) {\n", indent);
        out.format("%s      this.values = values;\n", indent);
        out.format("%s    }    \n", indent);
        for (PrismWriter w : writers) {
            out.format("%s    /** Return the AnnotationValue corresponding to the %s() \n", indent, w.name);
            out.format("%s     * member of the annotation, or null when the default value is implied.\n", indent);
            out.format("%s     */\n", indent);
            out.format("%s    %sAnnotationValue %s(){ return values.get(\"%s\");}\n", indent, access, w.name, w.name);
        }
        out.format("%s  }\n\n", indent);
        this.generateFixedClassContent(indent, out, outerName, writeValue, writeArrayValue);
    }

    private PrismWriter getWriter(ExecutableElement m, String access, Map<DeclaredType, String> otherPrisms) {
        WildcardType q = this.types.getWildcardType(null, null);
        DeclaredType enumType = this.types.getDeclaredType(this.elements.getTypeElement("java.lang.Enum"), q);
        TypeMirror typem = m.getReturnType();
        PrismWriter result = null;
        if (typem.getKind() == TypeKind.ARRAY) {
            typem = ((ArrayType)typem).getComponentType();
            result = new PrismWriter(m, true, access);
        } else {
            result = new PrismWriter(m, false, access);
        }
        if (typem.getKind().isPrimitive()) {
            String typeName = this.types.boxedClass((PrimitiveType)typem).getSimpleName().toString();
            result.setMirrorType(typeName);
            result.setPrismType(typeName);
        } else if (typem.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)typem;
            if (this.types.isSameType(type, this.elements.getTypeElement("java.lang.String").asType())) {
                result.setMirrorType("String");
                result.setPrismType("String");
            } else if (type.asElement().equals(this.elements.getTypeElement("java.lang.Class"))) {
                result.setMirrorType("TypeMirror");
                result.setPrismType("TypeMirror");
            } else if (this.types.isSubtype(type, enumType)) {
                result.setMirrorType("VariableElement");
                result.setPrismType("String");
                result.setM2pFormat("%s.getSimpleName().toString()");
            } else if (this.types.isSubtype(type, this.elements.getTypeElement("java.lang.annotation.Annotation").asType())) {
                result.setMirrorType("AnnotationMirror");
                DeclaredType annType = type;
                String prismName = null;
                for (Map.Entry<DeclaredType, String> entry : otherPrisms.entrySet()) {
                    if (!this.types.isSameType(entry.getKey(), annType)) continue;
                    prismName = entry.getValue();
                    break;
                }
                if (prismName != null) {
                    result.setPrismType(prismName);
                    result.setM2pFormat(prismName + ".getInstance(%s)");
                } else {
                    String prismType = annType.asElement().getSimpleName().toString() + "Prism";
                    result.setPrismType(prismType);
                    result.setM2pFormat(prismType + ".getInstance(%s)");
                    if (this.seenInners.add(type)) {
                        this.inners.add(type);
                    }
                }
            } else {
                ProcessingContext.logDebug("Unprocessed type" + type, new Object[0]);
            }
        }
        return result;
    }

    private void generateStaticMembers(PrintWriter out, boolean generateGetMirrors, boolean generateValue, boolean generateArray) {
        out.print("  private static AnnotationMirror getMirror(Element target) {\n    for (final var m : target.getAnnotationMirrors()) {\n      final CharSequence mfqn = ((TypeElement) m.getAnnotationType().asElement()).getQualifiedName();\n      if (PRISM_TYPE.contentEquals(mfqn)) return m;\n    }\n    return null;\n  }\n\n");
        if (generateGetMirrors) {
            out.print("  private static Stream<? extends AnnotationMirror> getMirrors(Element target) {\n    return target.getAnnotationMirrors().stream()\n        .filter(\n             m -> PRISM_TYPE.contentEquals(((TypeElement) m.getAnnotationType().asElement()).getQualifiedName()));\n  }\n\n");
        }
        if (generateValue) {
            out.print("  private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {\n    AnnotationValue av = memberValues.get(name);\n    if (av == null) av = defaults.get(name);\n    if (av == null) {\n      return null;\n    }\n    if (clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());\n    return null;\n  }\n\n");
        }
        if (generateArray) {
            out.print("  private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, final Class<T> clazz) {\n    AnnotationValue av = memberValues.get(name);\n    if (av == null) av = defaults.get(name);\n    if (av == null) {\n      return List.of();\n    }\n    if (av.getValue() instanceof List) {\n      final List<T> result = new ArrayList<>();\n      for (final var v : getValueAsList(av)) {\n        if (clazz.isInstance(v.getValue())) {\n          result.add(clazz.cast(v.getValue()));\n        } else {\n          return List.of();\n        }\n      }\n      return result;\n    } else {\n      return List.of();\n    }\n  }\n\n  @SuppressWarnings(\"unchecked\")\n  private static List<AnnotationValue> getValueAsList(AnnotationValue av) {\n    return (List<AnnotationValue>) av.getValue();\n  }\n");
        }
    }

    private void generateFixedClassContent(String indent, PrintWriter out, String outerName, boolean generateValue, boolean generateArray) {
        out.format("%s  private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);\n", indent);
        out.format("%s  private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);\n", indent);
        out.format("%s  private boolean valid = true;\n", indent);
        out.format("\n", new Object[0]);
        if (generateValue) {
            out.format("%s  private <T> T getValue(String name, Class<T> clazz) {\n", indent);
            out.format("%s    final T result = %s.getValue(memberValues, defaults, name, clazz);\n", indent, outerName);
            out.format("%s    if (result == null) valid = false;\n", indent);
            out.format("%s    return result;\n", indent);
            out.format("%s  }\n", indent);
            out.format("\n", new Object[0]);
        }
        if (generateArray) {
            out.format("%s  private <T> List<T> getArrayValues(String name, final Class<T> clazz) {\n", indent);
            out.format("%s    final List<T> result = %s.getArrayValues(memberValues, defaults, name, clazz);\n", indent, outerName);
            out.format("%s    if (result == null) valid = false;\n", indent);
            out.format("%s    return result;\n", indent);
            out.format("%s  }\n", indent);
        }
    }
}

