/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.prism.internal;

import io.avaje.prism.internal.GenerateContext;
import io.avaje.prism.internal.Util;
import java.io.PrintWriter;
import javax.lang.model.type.DeclaredType;

public class FactoryMethodWriter {
    private final String indent;
    private final PrintWriter out;
    private final String name;
    private final DeclaredType typeMirror;
    private final String access;
    private final String annName;
    private final boolean inner;
    private final boolean repeatable;
    private final boolean meta;

    FactoryMethodWriter(GenerateContext ctx, boolean inner) {
        this.indent = ctx.indent();
        this.out = ctx.out();
        this.name = ctx.name();
        this.typeMirror = ctx.typeMirror();
        this.access = ctx.access();
        this.annName = ctx.annName();
        this.inner = inner;
        this.repeatable = Util.isRepeatable(this.typeMirror);
        this.meta = Util.isMeta(this.typeMirror);
    }

    void write() {
        if (!this.inner) {
            this.writeIsPresent();
            this.writeGetInstanceOn();
            this.writeGetOptionalOn();
            if (this.repeatable) {
                this.writeGetAllInstances();
            }
            if (this.meta) {
                this.writeGetAllOnMeta();
            }
        }
        this.writeGetInstance();
        this.writeGetOptional();
    }

    private void writeIsPresent() {
        this.out.format("%s  /** Returns true if the prism annotation is present on the element, else false.\n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @return true if prism is present. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic boolean isPresent(Element element) {\n", this.indent, this.access);
        this.out.format("%s    return getInstanceOn(element) != null;\n", this.indent);
        this.out.format("%s  }\n\n", this.indent);
    }

    private void writeGetInstanceOn() {
        this.out.format("%s  /** Return a prism representing the {@code @%s} annotation on 'e'. \n", this.indent, this.annName);
        this.out.format("%s   * similar to {@code element.getAnnotation(%s.class)} except that \n", this.indent, this.annName);
        this.out.format("%s   * an instance of this class rather than an instance of {@code %s}\n", this.indent, this.annName);
        this.out.format("%s   * is returned.\n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @return prism for element or null if no annotation is found. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic %s getInstanceOn(Element element) {\n", this.indent, this.access, this.name);
        this.out.format("%s    final var mirror = getMirror(element);\n", this.indent);
        this.out.format("%s    if (mirror == null) return null;\n", this.indent);
        this.out.format("%s    return getInstance(mirror);\n", this.indent);
        this.out.format("%s  }\n\n", this.indent);
    }

    void writeGetOptionalOn() {
        this.out.format("%s  /** Return a Optional representing a nullable {@code @%s} annotation on 'e'. \n", this.indent, this.annName);
        this.out.format("%s   * similar to {@code element.getAnnotation(%s.class)} except that \n", this.indent, this.annName);
        this.out.format("%s   * an Optional of this class rather than an instance of {@code %s}\n", this.indent, this.annName);
        this.out.format("%s   * is returned.\n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @return prism optional for element. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic Optional<%s> getOptionalOn(Element element) {\n", this.indent, this.access, this.name);
        this.out.format("%s    final var mirror = getMirror(element);\n", this.indent);
        this.out.format("%s    if (mirror == null) return Optional.empty();\n", this.indent);
        this.out.format("%s    return getOptional(mirror);\n", this.indent);
        this.out.format("%s  }\n\n", this.indent);
    }

    private void writeGetAllOnMeta() {
        this.out.format("%s  /** Return a list of prisms representing the {@code @%s} meta annotation on all the annotations on the given element. \n", this.indent, this.annName);
        this.out.format("%s   * this method will recursively search all the annotations on the element. \n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @return list of prisms on the element's annotation. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic List<%s> getAllOnMetaAnnotations(Element element) {\n", this.indent, this.access, this.name);
        this.out.format("%s    if (element == null || element.getAnnotationMirrors().isEmpty()) return List.of();\n\n", this.indent);
        this.out.format("%s    //use a hashset to keep track of seen annotations \n", this.indent);
        this.out.format("%s    return getAllOnMetaAnnotations(element, new HashSet<>()).collect(toList());\n", this.indent);
        this.out.format("%s  }\n\n", this.indent);
        this.out.format("%s  /** Recursively search annotations elements for prisms.\n", this.indent);
        this.out.format("%s   * Uses a set to keep track of known annotations to avoid repeats/recursive loop. \n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @param seen set that tracks seen elements. \n", this.indent);
        this.out.format("%s   * @return stream of prisms on the element's annotation. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  private static Stream<%s> getAllOnMetaAnnotations(Element element, Set<String> seen) {\n", this.indent, this.name);
        this.out.format("%s    if (element == null || element.getAnnotationMirrors().isEmpty()) return Stream.of();\n\n", this.indent);
        this.out.format("%s    return element.getAnnotationMirrors().stream()\n", this.indent);
        this.out.format("%s      .map(AnnotationMirror::getAnnotationType)\n", this.indent);
        this.out.format("%s      //only search annotations \n", this.indent);
        this.out.format("%s      .filter(t -> seen.add(t.toString()))\n", this.indent);
        this.out.format("%s        .map(DeclaredType::asElement)\n", this.indent);
        this.out.format("%s        .flatMap(\n", this.indent);
        this.out.format("%s            e ->\n", this.indent);
        this.out.format("%s                Stream.concat(\n", this.indent);
        this.out.format("%s                    getAllOnMetaAnnotations(e, seen),\n", this.indent);
        this.out.format("%s                    getMirrors(element).map(%s::getInstance)));\n", this.indent, this.name);
        this.out.format("%s  }\n\n", this.indent);
    }

    private void writeGetAllInstances() {
        this.out.format("%s  /** Return a list of prisms representing the {@code @%s} annotation on 'e'. \n", this.indent, this.annName);
        this.out.format("%s   * similar to {@code e.getAnnotationsByType(%s.class)} except that \n", this.indent, this.annName);
        this.out.format("%s   * instances of this class rather than instances of {@code %s}\n", this.indent, this.annName);
        this.out.format("%s   * is returned.\n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param element element. \n", this.indent);
        this.out.format("%s   * @return list of prisms on the element. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic List<%s> getAllInstancesOn(Element element) {\n", this.indent, this.access, this.name);
        this.out.format("%s    return getMirrors(element)\n", this.indent);
        this.out.format("%s        .map(%s::getInstance)\n", this.indent, this.name);
        this.out.format("%s        .collect(toList());\n", this.indent);
        this.out.format("%s  }\n\n", this.indent);
    }

    private void writeGetInstance() {
        this.out.format("%s  /** Return a prism of the {@code @%s} annotation whose mirror is mirror. \n", this.indent, this.annName);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param mirror mirror. \n", this.indent);
        this.out.format("%s   * @return prism for mirror or null if mirror is an incorrect type. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic %s getInstance(AnnotationMirror mirror) {\n", this.indent, this.inner ? "private " : this.access, this.name);
        this.out.format("%s    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return null;\n\n", this.indent);
        this.out.format("%s    return new %s(mirror);\n", this.indent, this.name);
        this.out.format("%s  }\n\n", this.indent);
    }

    private void writeGetOptional() {
        this.out.format("%s  /** Return a {@code Optional<%s>} representing a {@code @%s} annotation mirror. \n", this.indent, this.name, this.annName);
        this.out.format("%s   * similar to {@code e.getAnnotation(%s.class)} except that \n", this.indent, this.annName);
        this.out.format("%s   * an Optional of this class rather than an instance of {@code %s}\n", this.indent, this.annName);
        this.out.format("%s   * is returned.\n", this.indent);
        this.out.format("%s   *\n", this.indent);
        this.out.format("%s   * @param mirror mirror. \n", this.indent);
        this.out.format("%s   * @return prism optional for mirror. \n", this.indent);
        this.out.format("%s   */\n", this.indent);
        this.out.format("%s  %sstatic Optional<%s> getOptional(AnnotationMirror mirror) {\n", this.indent, this.inner ? "private " : this.access, this.name);
        this.out.format("%s    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return Optional.empty();\n\n", this.indent);
        this.out.format("%s    return Optional.of(new %s(mirror));\n", this.indent, this.name);
        this.out.format("%s  }\n\n", this.indent);
    }
}

