/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.ComponentMetaData;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

final class SimpleComponentWriter {
    private final ComponentMetaData metaData;
    private final Set<String> importTypes = new TreeSet<String>();
    private Append writer;
    private JavaFileObject fileObject;

    SimpleComponentWriter(ComponentMetaData metaData) {
        this.metaData = metaData;
    }

    void initialise() throws IOException {
        String name = this.metaData.fullName();
        if (this.fileObject == null) {
            this.fileObject = APContext.createSourceFile(name, new Element[0]);
        }
        if (!this.metaData.isEmpty()) {
            ProcessingContext.addJsonSpi(this.metaData.fullName());
            ProcessingContext.validateModule();
        }
    }

    private Writer createFileWriter() throws IOException {
        return this.fileObject.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeRegister();
        this.writeClassEnd();
        this.writer.close();
    }

    void writeMetaInf() throws IOException {
        Set<String> services = ProcessingContext.readExistingMetaInfServices();
        FileObject fileObject = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.jsonb.spi.JsonbExtension");
        if (fileObject != null) {
            Writer writer = fileObject.openWriter();
            writer.write(String.join((CharSequence)"\n", services));
            writer.close();
        }
    }

    private void writeRegister() {
        String adapterShortName;
        this.writer.append("  @Override").eol();
        this.writer.append("  public void register(Jsonb.Builder builder) {").eol();
        for (String adapterFullName : this.metaData.withTypes()) {
            adapterShortName = Util.shortName(adapterFullName);
            this.writer.append("    builder.add(%s.class, %s::new);", adapterShortName, adapterShortName).eol();
        }
        for (String adapterFullName : this.metaData.allFactories()) {
            adapterShortName = Util.shortName(adapterFullName);
            this.writer.append("    builder.add(%s.FACTORY);", adapterShortName).eol();
        }
        for (String adapterFullName : this.metaData.all()) {
            adapterShortName = Util.shortName(adapterFullName);
            String typeName = Util.shortType(Util.baseTypeOfAdapter(adapterFullName).replace("$", "."));
            this.writer.append("    builder.add(%s.class, %s::new);", typeName, adapterShortName).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        String fullName = this.metaData.fullName();
        String shortName = Util.shortName(fullName);
        this.writer.append("@Generated(\"io.avaje.jsonb.generator\")").eol();
        List<String> factories = this.metaData.allFactories();
        if (!factories.isEmpty()) {
            this.writer.append("@MetaData.JsonFactory({");
            this.writeMetaDataEntry(factories);
            this.writer.append("})").eol();
        }
        this.writer.append("@MetaData({");
        ArrayList<String> all = new ArrayList<String>(this.metaData.all());
        all.addAll(this.metaData.withTypes());
        this.writeMetaDataEntry(all);
        this.writer.append("})").eol();
        this.writer.append("public %sclass %s implements GeneratedComponent {", Util.valhalla(), shortName).eol().eol();
    }

    private void writeMetaDataEntry(List<String> entries) {
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            this.writer.append("%s.class", Util.shortName(entries.get(i)));
        }
    }

    private void writeImports() {
        this.importTypes.add("io.avaje.jsonb.Jsonb");
        this.importTypes.addAll(this.metaData.allImports());
        this.importTypes.add("io.avaje.jsonb.spi.Generated");
        this.importTypes.add("io.avaje.jsonb.spi.GeneratedComponent");
        this.importTypes.add("io.avaje.jsonb.spi.MetaData");
        for (String importType : this.importTypes) {
            if (!Util.validImportType(importType, this.metaData.packageName())) continue;
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        String packageName = this.metaData.packageName();
        if (packageName != null && !packageName.isEmpty()) {
            this.writer.append("package %s;", packageName).eol().eol();
        }
    }
}

