/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.CreatorPrism;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.PrimitiveUtil;
import io.avaje.jsonb.generator.Util;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class ValueReader
implements BeanReader {
    private final ExecutableElement method;
    private final TypeElement element;
    private final String shortName;
    private final String type;
    private final Set<String> importTypes = new TreeSet<String>();
    private final String returnTypeStr;
    private final GenericType genericType;
    private final String adapterShortType;
    private final boolean isEnum;
    private final ExecutableElement constructor;

    ValueReader(TypeElement beanType, ExecutableElement e) {
        this.method = e;
        this.element = beanType;
        this.isEnum = beanType.getKind() == ElementKind.ENUM;
        TypeMirror returnType = e.getReturnType();
        this.returnTypeStr = PrimitiveUtil.wrap(Util.shortType(returnType.toString()));
        this.type = Util.trimAnnotations(returnType.toString());
        this.shortName = this.shortName(beanType);
        this.genericType = GenericType.parse(returnType.toString());
        String shortType = this.genericType.shortType();
        this.adapterShortType = "JsonAdapter<" + PrimitiveUtil.wrap(Util.shortType(shortType)) + ">";
        this.constructor = beanType.getEnclosedElements().stream().filter(CreatorPrism::isPresent).findFirst().map(ExecutableElement.class::cast).or(() -> ElementFilter.constructorsIn(this.element.getEnclosedElements()).stream().filter(s -> s.getParameters().size() == 1).filter(s -> Util.trimAnnotations(returnType.toString()).equals(Util.trimAnnotations(s.getParameters().get(0).asType().toString()))).findFirst()).orElse(null);
    }

    @Override
    public void read() {
    }

    @Override
    public void cascadeTypes(Set<String> extraTypes) {
        extraTypes.add(this.returnTypeStr);
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public TypeElement beanType() {
        return this.element;
    }

    private Set<String> importTypes() {
        this.importTypes.add("java.io.IOException");
        this.importTypes.add("java.util.EnumMap");
        this.importTypes.add("java.util.HashMap");
        this.importTypes.add("java.util.Map");
        this.importTypes.add(this.type);
        this.importTypes.add(this.element.asType().toString());
        this.importTypes.add(this.method.getReturnType().toString());
        this.importTypes.add("io.avaje.jsonb.spi.PropertyNames");
        this.importTypes.add("io.avaje.jsonb.JsonAdapter");
        this.importTypes.add("io.avaje.jsonb.JsonDataException");
        this.importTypes.add("io.avaje.jsonb.JsonReader");
        this.importTypes.add("io.avaje.jsonb.JsonWriter");
        this.importTypes.add("io.avaje.jsonb.spi.Generated");
        this.importTypes.add("io.avaje.jsonb.Jsonb");
        return this.importTypes;
    }

    @Override
    public void writeImports(Append writer, String packageName) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType, packageName)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    @Override
    public void writeFields(Append writer) {
        if (this.isEnum) {
            writer.append("  private static final Map<%s, %s> toValue = new EnumMap<>(%s.class);", this.shortName, this.returnTypeStr, this.shortName).eol();
            writer.append("  private static final Map<%s, %s> toEnum = new HashMap<>();", this.returnTypeStr, this.shortName).eol();
        }
        writer.append("  private final %s adapter;", this.adapterShortType).eol().eol();
    }

    @Override
    public void writeConstructor(Append writer) {
        writer.append("    this.adapter = jsonb.adapter(%s);", this.genericType.asTypeDeclaration().replace("? extends ", "")).eol();
        if (this.isEnum) {
            writer.append("    if (toValue.isEmpty()) {").eol();
            writer.append("      for (final var enumConst : %s.values()) {", this.shortName).eol();
            writer.append("        var val = enumConst.%s();", this.method.getSimpleName()).eol();
            writer.append("        toValue.put(enumConst, val);").eol();
            writer.append("        if (toEnum.containsKey(val)) throw new IllegalArgumentException(\"Duplicate value \" + val + \" from enum method %s. @Json.Value methods must return unique values\");", this.method.getSimpleName()).eol();
            writer.append("        toEnum.put(val, enumConst);").eol();
            writer.append("      }").eol();
            writer.append("    }").eol();
        }
    }

    @Override
    public void writeToJson(Append writer) {
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public void toJson(JsonWriter writer, %s value) {", this.shortName).eol();
        if (this.isEnum) {
            writer.append("    adapter.toJson(writer, toValue.get(value));").eol();
        } else {
            writer.append("    adapter.toJson(writer, value.%s());", this.method.getSimpleName()).eol();
        }
        writer.append("  }").eol();
    }

    @Override
    public void writeFromJson(Append writer) {
        String varName = Util.initLower(this.shortName);
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public %s fromJson(JsonReader reader) {", this.shortName).eol();
        if (!this.isEnum) {
            String constructMethod = this.constructor.getKind() == ElementKind.CONSTRUCTOR ? "new " + this.shortName : this.shortName + "." + String.valueOf(this.constructor.getSimpleName());
            writer.append("    return %s(adapter.fromJson(reader));", constructMethod).eol();
        } else {
            writer.append("    final var value = adapter.fromJson(reader);").eol();
            writer.append("    final var enumConstant = toEnum.get(value);").eol();
            writer.append("    if (enumConstant == null) ", varName).eol();
            writer.append("      throw new JsonDataException(\"Unable to determine %s enum value for \" + value);", this.shortName).eol();
            writer.append("    return enumConstant;").eol();
        }
        writer.append("  }").eol();
    }

    @Override
    public boolean supportsViewBuilder() {
        return false;
    }
}

