/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ProcessorUtils;
import io.avaje.jsonb.generator.UType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor9;

class TypeMirrorVisitor
extends AbstractTypeVisitor9<StringBuilder, StringBuilder>
implements UType {
    private final int depth;
    private final boolean includeAnnotations;
    private final Map<TypeVariable, String> typeVariables;
    private Set<String> allTypes = new HashSet<String>();
    private String mainType;
    private String fullType;
    private final List<UType> params = new ArrayList<UType>();
    private final List<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>();
    private List<AnnotationMirror> everyAnnotation = new ArrayList<AnnotationMirror>();
    private String shortType;
    private TypeKind kind;

    public static TypeMirrorVisitor create(TypeMirror typeMirror) {
        return TypeMirrorVisitor.create(typeMirror, true);
    }

    public static TypeMirrorVisitor create(TypeMirror typeMirror, boolean includedAnnotations) {
        TypeMirrorVisitor v = new TypeMirrorVisitor(1, Map.of(), includedAnnotations);
        StringBuilder b = new StringBuilder();
        v.fullType = typeMirror.accept(v, b).toString();
        return v;
    }

    private TypeMirrorVisitor() {
        this(1, new HashMap<TypeVariable, String>(), true);
    }

    private TypeMirrorVisitor(int depth, Map<TypeVariable, String> typeVariables, boolean includeAnnotations) {
        this.includeAnnotations = includeAnnotations;
        this.depth = depth;
        this.typeVariables = new HashMap<TypeVariable, String>();
        this.typeVariables.putAll(typeVariables);
    }

    @Override
    public Set<String> importTypes() {
        return this.allTypes.stream().filter(this::notJavaLang).collect(Collectors.toSet());
    }

    private boolean notJavaLang(String type) {
        return !type.startsWith("java.lang.") || Character.isLowerCase(type.charAt(10));
    }

    @Override
    public String shortType() {
        if (this.shortType == null) {
            this.shortType = TypeMirrorVisitor.shortRawType(this.fullType, this.allTypes);
        }
        return this.shortType;
    }

    @Override
    public String full() {
        return this.fullType;
    }

    @Override
    public boolean isGeneric() {
        return this.fullType.contains("<");
    }

    @Override
    public List<UType> componentTypes() {
        return this.params;
    }

    @Override
    public List<AnnotationMirror> annotations() {
        return this.annotations;
    }

    @Override
    public List<AnnotationMirror> allAnnotationsInType() {
        return this.everyAnnotation;
    }

    @Override
    public String mainType() {
        return this.mainType;
    }

    @Override
    public UType param0() {
        return this.params.isEmpty() ? null : this.params.get(0);
    }

    @Override
    public UType param1() {
        return this.params.size() < 2 ? null : this.params.get(1);
    }

    @Override
    public TypeKind kind() {
        return this.kind;
    }

    private static String shortRawType(String rawType, Set<String> allTypes) {
        LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
        for (String val : allTypes) {
            typeMap.put(val, ProcessorUtils.shortType(val));
        }
        String shortRaw = rawType;
        for (Map.Entry entry : typeMap.entrySet()) {
            shortRaw = shortRaw.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return shortRaw;
    }

    private void child(TypeMirror ct, StringBuilder p, boolean setMain) {
        String full;
        TypeMirrorVisitor child = new TypeMirrorVisitor(this.depth + 1, this.typeVariables, this.includeAnnotations);
        child.allTypes = this.allTypes;
        child.everyAnnotation = this.everyAnnotation;
        child.fullType = full = ct.accept(child, new StringBuilder()).toString();
        this.params.add(child);
        p.append(full);
        if (setMain) {
            this.mainType = child.mainType;
        }
    }

    private void child(TypeMirror ct, StringBuilder p) {
        this.child(ct, p, false);
    }

    @Override
    public StringBuilder visitPrimitive(PrimitiveType t, StringBuilder p) {
        this.kind = t.getKind();
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                p.append(annotationMirror.toString()).append(" ");
                this.annotations.add(annotationMirror);
                this.everyAnnotation.add(annotationMirror);
            }
        }
        String primitiveStr = t.getKind().toString().toLowerCase(Locale.ROOT);
        if (this.mainType == null) {
            this.mainType = primitiveStr;
        }
        p.append(primitiveStr);
        return p;
    }

    @Override
    public StringBuilder visitNull(NullType t, StringBuilder p) {
        return p;
    }

    @Override
    public StringBuilder visitArray(ArrayType t, StringBuilder p) {
        this.kind = t.getKind();
        boolean mainUnset = this.mainType == null;
        TypeMirror ct = t.getComponentType();
        this.child(ct, p, true);
        boolean first = true;
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                if (first) {
                    p.append(" ");
                    first = false;
                }
                p.append(annotationMirror.toString()).append(" ");
                this.annotations.add(annotationMirror);
                this.everyAnnotation.add(annotationMirror);
            }
        }
        p.append("[]");
        if (mainUnset) {
            this.mainType = this.mainType + "[]";
        }
        return p;
    }

    @Override
    public StringBuilder visitDeclared(DeclaredType t, StringBuilder p) {
        this.kind = t.getKind();
        String fqn = this.fullyQualfiedName(t, this.includeAnnotations);
        String trimmed = this.fullyQualfiedName(t, false);
        this.allTypes.add(ProcessorUtils.extractEnclosingFQN(trimmed));
        if (this.mainType == null) {
            this.mainType = trimmed;
        }
        p.append(fqn);
        List<? extends TypeMirror> tas = t.getTypeArguments();
        if (!tas.isEmpty()) {
            p.append("<");
            boolean first = true;
            for (TypeMirror typeMirror : tas) {
                if (!first) {
                    p.append(", ");
                }
                this.child(typeMirror, p);
                first = false;
            }
            p.append(">");
        }
        return p;
    }

    String fullyQualfiedName(DeclaredType t, boolean includeAnnotations) {
        Element element;
        TypeElement element2 = (TypeElement)t.asElement();
        List<? extends AnnotationMirror> typeUseAnnotations = t.getAnnotationMirrors();
        if (typeUseAnnotations.isEmpty() || !includeAnnotations) {
            return element2.getQualifiedName().toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.depth < 3) {
            for (AnnotationMirror annotationMirror : typeUseAnnotations) {
                sb.append(annotationMirror.toString()).append(" ");
            }
        }
        Object enclosedPart = (element = element2.getEnclosingElement()) instanceof QualifiedNameable ? ((QualifiedNameable)element).getQualifiedName().toString() + "." : "";
        sb.append((String)enclosedPart);
        if (this.depth > 2) {
            for (AnnotationMirror annotationMirror : typeUseAnnotations) {
                sb.append(annotationMirror.toString()).append(" ");
            }
        }
        for (AnnotationMirror annotationMirror : typeUseAnnotations) {
            TypeElement annotation = (TypeElement)annotationMirror.getAnnotationType().asElement();
            this.allTypes.add(annotation.getQualifiedName().toString());
            this.annotations.add(annotationMirror);
            this.everyAnnotation.add(annotationMirror);
        }
        sb.append(element2.getSimpleName());
        return sb.toString();
    }

    @Override
    public StringBuilder visitError(ErrorType t, StringBuilder p) {
        this.kind = t.getKind();
        return p;
    }

    @Override
    public StringBuilder visitTypeVariable(TypeVariable t, StringBuilder p) {
        this.kind = t.getKind();
        String previous = this.typeVariables.get(t);
        if (previous != null) {
            p.append(previous);
            return p;
        }
        StringBuilder sb = new StringBuilder();
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                p.append(annotationMirror.toString()).append(" ");
                sb.append(annotationMirror.toString()).append(" ");
            }
        }
        String name = t.asElement().getSimpleName().toString();
        if (this.mainType == null) {
            this.mainType = name;
        }
        p.append(name);
        sb.append(name);
        this.typeVariables.put(t, sb.toString());
        TypeMirror typeMirror = t.getUpperBound();
        if (typeMirror != null) {
            this.child(typeMirror, new StringBuilder());
        }
        return p;
    }

    @Override
    public StringBuilder visitWildcard(WildcardType t, StringBuilder p) {
        this.kind = t.getKind();
        TypeMirror extendsBound = t.getExtendsBound();
        TypeMirror superBound = t.getSuperBound();
        this.kind = t.getKind();
        this.mainType = "?";
        for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
            p.append(annotationMirror.toString()).append(" ");
        }
        if (extendsBound != null) {
            p.append("? extends ");
            this.child(extendsBound, p);
        } else if (superBound != null) {
            p.append("? super ");
            this.child(superBound, p);
        } else {
            p.append("?");
        }
        return p;
    }

    @Override
    public StringBuilder visitExecutable(ExecutableType t, StringBuilder p) {
        throw new UnsupportedOperationException("Does not support ExecutableType");
    }

    @Override
    public StringBuilder visitNoType(NoType t, StringBuilder p) {
        this.kind = t.getKind();
        this.mainType = t.toString();
        return p.append(this.mainType);
    }

    @Override
    public StringBuilder visitIntersection(IntersectionType t, StringBuilder p) {
        this.kind = t.getKind();
        boolean first = true;
        for (TypeMirror typeMirror : t.getBounds()) {
            if (first) {
                first = false;
            } else {
                p.append(" & ");
            }
            this.child(typeMirror, p);
        }
        return p;
    }

    @Override
    public StringBuilder visitUnion(UnionType t, StringBuilder p) {
        this.kind = t.getKind();
        boolean first = true;
        for (TypeMirror typeMirror : t.getAlternatives()) {
            if (first) {
                first = false;
            } else {
                p.append(" | ");
            }
            this.child(typeMirror, p);
        }
        return p;
    }

    public String toString() {
        return this.fullType;
    }

    public int hashCode() {
        return Objects.hash(this.fullType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeMirrorVisitor other = (TypeMirrorVisitor)obj;
        return Objects.equals(this.fullType, other.fullType);
    }
}

