/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.tools.StandardLocation;

public class ModuleInfoReader {
    private static final String SPLIT_PATTERN = "\\s*,\\s*";
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w.$]+);");
    private static final Pattern REQUIRES_PATTERN = Pattern.compile("requires\\s+(transitive\\s+)?(static\\s+)?([\\w.$]+);");
    private static final Pattern PROVIDES_PATTERN = Pattern.compile("provides\\s+([\\w.$]+)\\s+with\\s+([\\w.$,\\s]+);");
    private static final Pattern OPENS_PATTERN = Pattern.compile("opens\\s+([\\w.$]+)\\s+to\\s+([\\w.$,\\s]+);");
    private static final Pattern EXPORTS_PATTERN = Pattern.compile("exports\\s+([\\w.$]+)\\s+to\\s+([\\w.$,\\s]+);");
    private static final Pattern USES_PATTERN = Pattern.compile("uses\\s+([\\w.$]+);");
    private final List<Requires> requires = new ArrayList<Requires>();
    private final List<Uses> uses = new ArrayList<Uses>();
    private final List<Exports> exports = new ArrayList<Exports>();
    private final List<Opens> opens = new ArrayList<Opens>();
    private final List<Provides> provides = new ArrayList<Provides>();
    private final ModuleElement moduleElement;

    public ModuleInfoReader() throws IOException {
        this(APContext.getProjectModuleElement(), APContext.getModuleInfoReader());
    }

    public ModuleInfoReader(ModuleElement moduleElement, BufferedReader reader) throws IOException {
        this(moduleElement, reader.lines().collect(Collectors.joining("\n")));
        reader.close();
    }

    public ModuleInfoReader(ModuleElement moduleElement, CharSequence moduleString) {
        this.moduleElement = moduleElement;
        Matcher importMatcher = IMPORT_PATTERN.matcher(moduleString);
        Matcher requiresMatcher = REQUIRES_PATTERN.matcher(moduleString);
        Matcher providesMatcher = PROVIDES_PATTERN.matcher(moduleString);
        Matcher opensMatcher = OPENS_PATTERN.matcher(moduleString);
        Matcher exportsMatcher = EXPORTS_PATTERN.matcher(moduleString);
        Matcher usesMatcher = USES_PATTERN.matcher(moduleString);
        while (requiresMatcher.find()) {
            boolean transitive = requiresMatcher.group(1) != null;
            boolean isStatic = requiresMatcher.group(2) != null;
            String dep = requiresMatcher.group(3);
            this.requires.add(new Requires(APContext.elements().getModuleElement(dep), transitive, isStatic));
        }
        while (opensMatcher.find()) {
            String packageName = opensMatcher.group(1);
            String targets = opensMatcher.group(2);
            List<ModuleElement> openTargets = Arrays.stream(targets.split(SPLIT_PATTERN)).map(APContext.elements()::getModuleElement).collect(Collectors.toList());
            this.opens.add(new Opens(moduleElement, packageName, openTargets));
        }
        while (exportsMatcher.find()) {
            String packageName = exportsMatcher.group(1);
            String targets = exportsMatcher.group(2);
            List<ModuleElement> exportTargets = Arrays.stream(targets.split(SPLIT_PATTERN)).map(APContext.elements()::getModuleElement).collect(Collectors.toList());
            this.exports.add(new Exports(moduleElement, packageName, exportTargets));
        }
        ArrayList<String> imports = new ArrayList<String>();
        while (importMatcher.find()) {
            imports.add(importMatcher.group(1));
        }
        while (providesMatcher.find()) {
            String providedInterface = this.resolveImport(imports, providesMatcher.group(1));
            String implementationClasses = providesMatcher.group(2);
            List<String> implementations = Arrays.stream(implementationClasses.split(SPLIT_PATTERN)).map(s -> this.resolveImport((List<String>)imports, (String)s)).collect(Collectors.toList());
            this.provides.add(new Provides(providedInterface, implementations));
        }
        while (usesMatcher.find()) {
            String usedInterface = this.resolveImport(imports, usesMatcher.group(1));
            this.uses.add(new Uses(usedInterface));
        }
    }

    private String resolveImport(List<String> imports, String providedInterface) {
        return imports.stream().filter(s -> s.contains(providedInterface)).findFirst().orElse(providedInterface).replaceAll("\\s", "");
    }

    public boolean containsOnModulePath(String moduleName) {
        if (this.requires.isEmpty()) {
            return false;
        }
        boolean surfaceCheck = this.requires.stream().filter(r -> !r.isStatic).anyMatch(r -> r.dependency.getQualifiedName().contentEquals(moduleName));
        if (surfaceCheck) {
            return true;
        }
        HashSet seen = new HashSet();
        return this.requires.parallelStream().filter(r -> !r.isStatic).anyMatch(r -> this.hasNonStaticModule(moduleName, r.dependency, seen));
    }

    private boolean hasNonStaticModule(String name, ModuleElement element, Set<String> seen) {
        if (!seen.add(element.getQualifiedName().toString())) {
            return false;
        }
        List directives = element.getDirectives().stream().filter(d -> d.getKind() == ModuleElement.DirectiveKind.REQUIRES).map(ModuleElement.RequiresDirective.class::cast).filter(r -> !r.isStatic()).collect(Collectors.toList());
        if (directives.isEmpty()) {
            return false;
        }
        boolean surfaceCheck = directives.stream().anyMatch(r -> r.getDependency().getQualifiedName().contentEquals(name));
        if (surfaceCheck) {
            return true;
        }
        return this.requires.stream().anyMatch(r -> this.hasNonStaticModule(name, r.getDependency(), seen));
    }

    private String replace$(String k) {
        return k.replace('$', '.');
    }

    public void validateServices(String providesType, Collection<String> implementations) {
        if (ModuleInfoReader.buildPluginAvailable() || this.moduleElement.isUnnamed() || APContext.isTestCompilation()) {
            return;
        }
        TreeSet<String> implSet = new TreeSet<String>(implementations);
        try (InputStream file2 = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + providesType).toUri().toURL().openStream();
             BufferedReader buffer = new BufferedReader(new InputStreamReader(file2));){
            String line;
            while ((line = buffer.readLine()) != null) {
                line.replaceAll("\\s", "").replace(",", "\n").lines().forEach(implSet::add);
            }
        }
        catch (Exception file2) {
            // empty catch block
        }
        Set missingImpls = implSet.stream().map(this::replace$).collect(Collectors.toSet());
        this.provides().forEach(p -> {
            String contract = this.replace$(providesType);
            if (!providesType.equals(contract)) {
                return;
            }
            List<String> impls = p.implementations();
            if (missingImpls.size() > impls.size()) {
                return;
            }
            impls.stream().map(this::replace$).forEach(missingImpls::remove);
        });
        if (!missingImpls.isEmpty()) {
            String message = implementations.stream().collect(Collectors.joining(", "));
            APContext.logError(this.moduleElement, "Missing `provides %s with %s;`", providesType, message);
        }
    }

    private static boolean buildPluginAvailable() {
        return ModuleInfoReader.isPresent("avaje-plugin-exists.txt");
    }

    private static boolean isPresent(String path) {
        try {
            return APContext.getBuildResource(path).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Requires> requires() {
        return this.requires;
    }

    public List<Uses> uses() {
        return this.uses;
    }

    public List<Exports> exports() {
        return this.exports;
    }

    public List<Opens> opens() {
        return this.opens;
    }

    public List<Provides> provides() {
        return this.provides;
    }

    public static class Requires {
        private final ModuleElement dependency;
        private final boolean isTransitive;
        private final boolean isStatic;

        public Requires(ModuleElement dependency, boolean isTransitive, boolean isStatic) {
            this.dependency = dependency;
            this.isTransitive = isTransitive;
            this.isStatic = isStatic;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isTransitive() {
            return this.isTransitive;
        }

        public ModuleElement getDependency() {
            return this.dependency;
        }
    }

    public static class Opens {
        private final ModuleElement parent;
        private final String packageName;
        private final List<ModuleElement> targets;

        public Opens(ModuleElement parent, String packageName, List<ModuleElement> targets) {
            this.parent = parent;
            this.packageName = packageName;
            this.targets = targets.isEmpty() ? null : targets;
        }

        public String packageName() {
            return this.packageName;
        }

        public PackageElement getPackage() {
            return APContext.elements().getPackageElement(this.parent, this.packageName);
        }

        public List<ModuleElement> getTargetModules() {
            return this.targets;
        }
    }

    public static class Exports {
        private final ModuleElement parent;
        private final String packageName;
        private final List<ModuleElement> targets;

        public Exports(ModuleElement parent, String packageName, List<ModuleElement> targets) {
            this.parent = parent;
            this.packageName = packageName;
            this.targets = targets.isEmpty() ? null : targets;
        }

        public String packageName() {
            return this.packageName;
        }

        public PackageElement getPackage() {
            return APContext.elements().getPackageElement(this.parent, this.packageName);
        }

        public List<ModuleElement> getTargetModules() {
            return this.targets;
        }
    }

    public static class Provides {
        private final String type;
        private final List<String> impls;

        public Provides(String type, List<String> impls) {
            this.type = type;
            this.impls = impls;
        }

        public String service() {
            return this.type;
        }

        public List<String> implementations() {
            return this.impls;
        }
    }

    public static class Uses {
        private final String service;

        public Uses(String usedInterface) {
            this.service = usedInterface;
        }

        public String service() {
            return this.service;
        }
    }
}

