/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class MethodReader {
    private final ExecutableElement element;
    private final String methodName;
    private final List<MethodParam> params = new ArrayList<MethodParam>();

    MethodReader(ExecutableElement element) {
        this.element = element;
        this.methodName = element.getSimpleName().toString();
    }

    public String toString() {
        return this.methodName;
    }

    TypeMirror returnType() {
        return this.element.getReturnType();
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        return this;
    }

    String getName() {
        return this.methodName;
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isProtected() {
        return this.element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    String creationString() {
        String shortName = Util.shortName(((TypeElement)this.element.getEnclosingElement()).getQualifiedName().toString());
        if (this.element.getKind() == ElementKind.CONSTRUCTOR) {
            return String.format("new %s(", shortName);
        }
        return String.format("%s.%s(", shortName, this.element.getSimpleName());
    }

    ExecutableElement element() {
        return this.element;
    }

    static class MethodParam {
        private final String simpleName;
        private final String type;
        private final VariableElement element;

        MethodParam(VariableElement param) {
            this.simpleName = param.getSimpleName().toString();
            this.type = param.asType().toString();
            this.element = param;
        }

        String name() {
            return this.simpleName;
        }

        public String type() {
            return this.type;
        }

        public VariableElement element() {
            return this.element;
        }
    }
}

