/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.GenericType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;

final class Util {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("\\s+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern COMMA_PATTERN = Pattern.compile(", (?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");

    Util() {
    }

    static boolean validImportType(String type) {
        return type.indexOf(46) > 0;
    }

    public static String sanitizeImports(String type) {
        int pos = type.indexOf("@");
        if (pos == -1) {
            return Util.trimArrayBrackets(type);
        }
        String start = pos == 0 ? type.substring(0, pos) : "";
        return start + Util.trimArrayBrackets(type.substring(type.lastIndexOf(32) + 1));
    }

    private static String trimArrayBrackets(String type) {
        return type.replaceAll("[^\\n\\r\\t $*_;\\w.]", "");
    }

    static String packageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        return pos == -1 ? "" : cls.substring(0, pos);
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String shortType(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        if (fullType.startsWith("java")) {
            return fullType.substring(p + 1);
        }
        Object result = "";
        boolean foundClass = false;
        for (String part : fullType.split("\\.")) {
            char firstChar = part.charAt(0);
            if (!foundClass && !Character.isUpperCase(firstChar) && (Character.isAlphabetic(firstChar) || !Character.isJavaIdentifierStart(firstChar))) continue;
            foundClass = true;
            result = (String)result + (((String)result).isEmpty() ? "" : ".") + part;
        }
        if (((String)result).isBlank()) {
            return fullType.substring(p + 1);
        }
        return result;
    }

    public static String trimAnnotations(String input) {
        input = COMMA_PATTERN.matcher(input).replaceAll(",");
        return Util.cutAnnotations(input);
    }

    private static String cutAnnotations(String input) {
        int pos = input.indexOf("@");
        if (pos == -1) {
            return input;
        }
        Matcher matcher = WHITE_SPACE_REGEX.matcher(input);
        int currentIndex = 0;
        if (matcher.find()) {
            currentIndex = matcher.start();
        }
        String result = input.substring(0, pos) + input.substring(currentIndex + 1);
        return Util.cutAnnotations(result);
    }

    static String commonParent(String currentTop, String aPackage) {
        int next;
        if (aPackage == null) {
            return currentTop;
        }
        if (currentTop == null) {
            return Util.packageOf(aPackage);
        }
        if (aPackage.startsWith(currentTop)) {
            return currentTop;
        }
        do {
            if ((next = currentTop.lastIndexOf(46)) <= -1 || !aPackage.startsWith(currentTop = currentTop.substring(0, next))) continue;
            return currentTop;
        } while (next > -1);
        return currentTop;
    }

    static String initCap(String input) {
        if (input.length() < 2) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    static List<String> escapeQuotes(List<String> all) {
        ArrayList<String> escaped = new ArrayList<String>(all.size());
        for (String raw : all) {
            escaped.add(Util.escapeQuotes(raw));
        }
        return escaped;
    }

    static String escapeQuotes(String input) {
        return input.replaceAll("^\"|\"$", "\\\\\"");
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toLower = true;
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                if (toLower) {
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
            toLower = false;
        }
        return sb.toString();
    }

    static String baseTypeOfAdapter(String adapterFullName) {
        TypeElement element = APContext.typeElement(adapterFullName);
        if (element == null) {
            throw new NullPointerException("Element not found for [" + adapterFullName + "]");
        }
        return Util.baseTypeOfAdapter(element);
    }

    static String baseTypeOfAdapter(TypeElement element) {
        return element.getInterfaces().stream().filter(t -> t.toString().contains("io.avaje.jsonb.JsonAdapter")).findFirst().map(Object::toString).map(GenericType::parse).map(GenericType::firstParamType).map(Util::extractTypeWithNest).orElseGet(() -> {
            APContext.logError(element, "Custom Adapters must implement JsonAdapter", new Object[0]);
            return "Invalid";
        });
    }

    static String extractTypeWithNest(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1 || fullType.startsWith("java")) {
            return fullType;
        }
        StringBuilder result = new StringBuilder();
        boolean foundClass = false;
        boolean firstClass = true;
        for (String part : fullType.split("\\.")) {
            if (Character.isUpperCase(part.charAt(0))) {
                foundClass = true;
            }
            result.append(foundClass && !firstClass ? "$" : ".").append(part);
            if (!foundClass) continue;
            firstClass = false;
        }
        if (result.charAt(0) == '.') {
            result.deleteCharAt(0);
        }
        return result.toString();
    }
}

