/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class SubTypePrism {
    private final TypeMirror _type;
    private final String _name;
    public static final String PRISM_TYPE = "io.avaje.jsonb.Json.SubType";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return SubTypePrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return SubTypePrism.getInstanceOn(element) != null;
    }

    static SubTypePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = SubTypePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return SubTypePrism.getInstance(mirror);
    }

    static Optional<SubTypePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = SubTypePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return SubTypePrism.getOptional(mirror);
    }

    static List<SubTypePrism> getAllInstancesOn(Element element) {
        return SubTypePrism.getMirrors(element).map(SubTypePrism::getInstance).collect(Collectors.toList());
    }

    static SubTypePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new SubTypePrism(mirror);
    }

    static Optional<SubTypePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new SubTypePrism(mirror));
    }

    private SubTypePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._type = this.getValue("type", TypeMirror.class);
        this._name = this.getValue("name", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public TypeMirror type() {
        return this._type;
    }

    public String name() {
        return this._name;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = SubTypePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue type() {
            return this.values.get("type");
        }

        AnnotationValue name() {
            return this.values.get("name");
        }
    }
}

