/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.PrimitiveUtil;
import io.avaje.jsonb.generator.Util;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class EnumReader
implements BeanReader {
    private final ExecutableElement method;
    private final TypeElement enumType;
    private final String shortName;
    private final String type;
    private final Set<String> importTypes = new TreeSet<String>();
    private final String returnTypeStr;
    private final GenericType genericType;
    private final String adapterShortType;

    EnumReader(TypeElement beanType, ExecutableElement e) {
        this.method = e;
        this.enumType = beanType;
        TypeMirror returnType = e.getReturnType();
        this.returnTypeStr = PrimitiveUtil.wrap(Util.shortType(returnType.toString()));
        this.type = Util.trimAnnotations(returnType.toString());
        this.shortName = this.shortName(beanType);
        this.genericType = GenericType.parse(this.returnTypeStr);
        String shortType = this.genericType.shortType();
        this.adapterShortType = "JsonAdapter<" + PrimitiveUtil.wrap(Util.shortType(shortType)) + ">";
    }

    @Override
    public void read() {
    }

    @Override
    public void cascadeTypes(Set<String> extraTypes) {
    }

    public String toString() {
        return this.enumType.toString();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public TypeElement beanType() {
        return this.enumType;
    }

    private Set<String> importTypes() {
        this.importTypes.add("io.avaje.jsonb.*");
        this.importTypes.add("java.io.IOException");
        this.importTypes.add("io.avaje.jsonb.spi.*");
        this.importTypes.add("java.util.EnumMap");
        this.importTypes.add("java.util.HashMap");
        this.importTypes.add("java.util.Map");
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.importTypes.add("io.avaje.jsonb.spi.*");
        this.importTypes.add(this.enumType.asType().toString());
        this.importTypes.add(this.method.getReturnType().toString());
        return this.importTypes;
    }

    @Override
    public void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    @Override
    public void writeFields(Append writer) {
        writer.append("  private static final Map<%s, %s> toValue = new EnumMap<>(%s.class);", this.shortName, this.returnTypeStr, this.shortName).eol();
        writer.append("  private static final Map<%s, %s> toEnum = new HashMap<>();", this.returnTypeStr, this.shortName).eol();
        writer.append("  private final %s adapter;", this.adapterShortType).eol();
        writer.eol();
    }

    @Override
    public void writeConstructor(Append writer) {
        writer.append("    this.adapter = jsonb.adapter(%s);", this.genericType.asTypeDeclaration()).eol();
        writer.append("    if(!toValue.isEmpty()) return;").eol();
        writer.append("    for(final var enumConst : %s.values()) {", this.shortName).eol();
        writer.append("      var val = enumConst.%s();", this.method.getSimpleName()).eol();
        writer.append("      toValue.put(enumConst, val);").eol();
        writer.append("      if(toEnum.containsKey(val)) throw new IllegalArgumentException(\"Duplicate value \"+ val + \" from enum method %s. @Json.Value methods must return unique values\");", this.method.getSimpleName()).eol();
        writer.append("      toEnum.put(val, enumConst);").eol();
        writer.append("    }").eol();
    }

    @Override
    public void writeToJson(Append writer) {
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public void toJson(JsonWriter writer, %s value) {", this.shortName).eol();
        writer.append("    adapter.toJson(writer, toValue.get(value));").eol();
        writer.append("  }").eol();
    }

    @Override
    public void writeFromJson(Append writer) {
        String varName = Util.initLower(this.shortName);
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public %s fromJson(JsonReader reader) {", this.shortName, varName).eol();
        writer.append("    final var value = adapter.fromJson(reader);").eol();
        writer.append("    final var enumConstant = toEnum.get(value);").eol();
        writer.append("    if (enumConstant == null) ", varName).eol();
        writer.append("      throw new JsonDataException(\"Unable to determine %s enum value for \" + value);", this.shortName).eol();
        writer.append("    return enumConstant;").eol();
        writer.append("  }").eol();
    }

    @Override
    public boolean supportsViewBuilder() {
        return false;
    }
}

