/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.APContext;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.GenericType;
import io.avaje.jsonb.generator.JsonPrism;
import io.avaje.jsonb.generator.MethodProperty;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.NamingConvention;
import io.avaje.jsonb.generator.NamingConventionReader;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.SubTypeRequest;
import io.avaje.jsonb.generator.TypeReader;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import io.avaje.jsonb.generator.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

final class ClassReader
implements BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final MethodReader constructor;
    private final List<FieldReader> allFields;
    private final List<MethodProperty> methodProperties;
    private final Set<String> importTypes = new TreeSet<String>();
    private final NamingConvention namingConvention;
    private final boolean hasSubTypes;
    private final TypeReader typeReader;
    private final String typeProperty;
    private final boolean nonAccessibleField;
    private final boolean caseInsensitiveKeys;
    private final boolean readOnlyInterface;
    private FieldReader unmappedField;
    private boolean hasRaw;
    private final boolean isRecord;
    private final boolean usesTypeProperty;
    private final boolean useEnum;
    private static final boolean useInstanceofPattern = APContext.jdkVersion() >= 17;
    private static final boolean nullSwitch = APContext.jdkVersion() >= 21 || APContext.jdkVersion() >= 17 && APContext.previewEnabled();
    private final Map<String, Integer> frequencyMap = new HashMap<String, Integer>();
    private final Map<String, Boolean> isCommonFieldMap = new HashMap<String, Boolean>();
    private final boolean optional;
    private final List<TypeSubTypeMeta> subTypes;
    private ClassReader implementation;

    ClassReader(TypeElement beanType) {
        this(beanType, null);
    }

    ClassReader(TypeElement beanType, TypeElement mixInElement) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        NamingConventionReader ncReader = new NamingConventionReader(beanType);
        this.namingConvention = ncReader.get();
        this.typeProperty = ncReader.typeProperty();
        this.caseInsensitiveKeys = ncReader.isCaseInsensitiveKeys();
        this.typeReader = new TypeReader(beanType, mixInElement, this.namingConvention, this.typePropertyKey());
        this.typeReader.process();
        this.nonAccessibleField = this.typeReader.nonAccessibleField();
        this.hasSubTypes = this.typeReader.hasSubTypes();
        this.allFields = this.typeReader.allFields();
        this.constructor = this.typeReader.constructor();
        this.optional = this.typeReader.hasOptional();
        this.isRecord = this.isRecord(beanType);
        this.subTypes = this.typeReader.subTypes();
        this.readOnlyInterface = this.allFields.isEmpty() && this.subTypes.isEmpty();
        this.methodProperties = this.typeReader.methodProperties();
        this.subTypes.stream().map(TypeSubTypeMeta::type).forEach(this.importTypes::add);
        Optional<FieldReader> userTypeField = this.allFields.stream().filter(f -> f.propertyName().equals(this.typePropertyKey())).findAny();
        this.usesTypeProperty = userTypeField.isPresent();
        this.useEnum = userTypeField.map(FieldReader::type).map(GenericType::topType).map(APContext::typeElement).filter(e -> e.getKind() == ElementKind.ENUM).isPresent();
    }

    boolean isRecord(TypeElement beanType) {
        try {
            List recordComponents = (List)TypeElement.class.getMethod("getRecordComponents", new Class[0]).invoke((Object)beanType, new Object[0]);
            return !recordComponents.isEmpty();
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    void setImplementationType(TypeElement implementationType) {
        this.implementation = new ClassReader(implementationType);
    }

    @Override
    public int genericTypeParamsCount() {
        return this.typeReader.genericTypeParamsCount();
    }

    public String toString() {
        return this.beanType.toString();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public TypeElement beanType() {
        return this.beanType;
    }

    List<FieldReader> allFields() {
        return this.allFields;
    }

    @Override
    public boolean supportsViewBuilder() {
        return !this.hasSubTypes;
    }

    @Override
    public boolean nonAccessibleField() {
        return this.nonAccessibleField;
    }

    @Override
    public boolean hasJsonAnnotation() {
        return JsonPrism.isPresent(this.beanType);
    }

    @Override
    public void read() {
        for (FieldReader field : this.allFields) {
            field.addImports(this.importTypes);
            if (field.isRaw()) {
                this.hasRaw = true;
            }
            if (!field.isUnmapped()) continue;
            this.unmappedField = field;
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            methodProperty.addImports(this.importTypes);
        }
    }

    private Set<String> importTypes() {
        if (this.genericTypeParamsCount() > 0) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("java.lang.reflect.ParameterizedType");
        }
        this.importTypes.add("io.avaje.jsonb.*");
        this.importTypes.add("java.io.IOException");
        this.importTypes.add("io.avaje.jsonb.spi.*");
        if (!this.hasSubTypes) {
            this.importTypes.add("java.lang.invoke.MethodHandle");
        }
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        for (FieldReader allField : this.allFields) {
            allField.addImports(this.importTypes);
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            methodProperty.addImports(this.importTypes);
        }
        if (this.implementation != null) {
            this.implementation.addImported(this.importTypes);
        }
        return this.importTypes;
    }

    private void addImported(Set<String> importTypes) {
        if (Util.validImportType(this.type)) {
            importTypes.add(this.type);
        }
    }

    @Override
    public void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    @Override
    public void cascadeTypes(Set<String> types) {
        for (FieldReader allField : this.allFields) {
            if (!allField.include()) continue;
            allField.cascadeTypes(types);
        }
    }

    @Override
    public void writeFields(Append writer) {
        writer.append("  // naming convention %s", this.namingConvention).eol();
        for (FieldReader allField : this.allFields) {
            allField.writeDebug(writer);
        }
        writer.eol();
        if (this.hasRaw) {
            writer.append("  private final JsonAdapter<String> rawAdapter;").eol();
        }
        HashSet<String> uniqueTypes = new HashSet<String>();
        if (this.hasSubTypes) {
            writer.append("  private final JsonAdapter<String> stringJsonAdapter;").eol();
            uniqueTypes.add("String");
        }
        for (FieldReader allField : this.allFields) {
            if (!allField.include() || allField.isRaw() || !uniqueTypes.add(allField.adapterShortType())) continue;
            allField.writeField(writer);
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            if (!uniqueTypes.add(methodProperty.adapterShortType())) continue;
            methodProperty.writeField(writer);
        }
        writer.append("  private final PropertyNames names;").eol();
        writer.eol();
    }

    @Override
    public void writeConstructor(Append writer) {
        if (this.hasRaw) {
            writer.append("    this.rawAdapter = jsonb.rawAdapter();").eol();
        }
        HashSet<String> uniqueTypes = new HashSet<String>();
        if (this.hasSubTypes) {
            writer.append("    this.stringJsonAdapter = jsonb.adapter(String.class);").eol();
            uniqueTypes.add("String");
        }
        for (FieldReader allField : this.allFields) {
            if (!allField.include() || allField.isRaw() || !uniqueTypes.add(allField.adapterShortType())) continue;
            if (this.hasSubTypes) {
                boolean isCommonDiffType = this.allFields.stream().filter(s -> s.fieldName().equals(allField.fieldName())).anyMatch(f -> !allField.adapterShortType().equals(f.adapterShortType()));
                this.isCommonFieldMap.put(allField.fieldName(), isCommonDiffType);
            }
            allField.writeConstructor(writer);
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            if (!uniqueTypes.add(methodProperty.adapterShortType())) continue;
            methodProperty.writeConstructor(writer);
        }
        writer.append("    this.names = jsonb.properties(");
        if (this.hasSubTypes) {
            writer.append("\"").append(this.typeProperty).append("\", ");
        }
        writer.append(this.propertyNames());
        writer.append(");").eol();
    }

    private String propertyNames() {
        return this.readOnlyInterface ? this.propertyNamesReadOnly() : this.propertyNamesFields();
    }

    private String propertyNamesFields() {
        StringBuilder builder = new StringBuilder();
        HashSet<String> seen = new HashSet<String>();
        int size = this.allFields.size();
        for (int i = 0; i < size; ++i) {
            FieldReader fieldReader = this.allFields.get(i);
            if (!seen.add(fieldReader.fieldName())) continue;
            if (i > 0) {
                builder.append(", ");
            }
            if (this.usesTypeProperty && fieldReader.propertyName().equals(this.typePropertyKey())) {
                builder.append(" ");
                continue;
            }
            builder.append("\"").append(fieldReader.propertyName()).append("\"");
        }
        return builder.toString().replace(" , ", "");
    }

    private String propertyNamesReadOnly() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.methodProperties.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("\"").append(this.methodProperties.get(i).propertyName()).append("\"");
        }
        return builder.toString().replace(" , ", "");
    }

    @Override
    public void writeViewSupport(Append writer) {
        if (!this.hasSubTypes) {
            this.writeView(writer);
            this.writeViewBuild(writer);
        }
    }

    private void writeView(Append writer) {
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public boolean isViewBuilderAware() {").eol();
        writer.append("    return true;").eol();
        writer.append("  }").eol().eol();
        writer.append("  @Override").eol();
        writer.append("  public ViewBuilderAware viewBuild() {").eol();
        writer.append("    return this;").eol();
        writer.append("  }").eol().eol();
    }

    private void writeViewBuild(Append writer) {
        writer.append("  @Override").eol();
        writer.append("  public void build(ViewBuilder builder, String name, MethodHandle handle) {").eol();
        writer.append("    builder.beginObject(name, handle);").eol();
        for (FieldReader allField : this.allFields) {
            if (!allField.includeToJson(null)) continue;
            allField.writeViewBuilder(writer, this.shortName);
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            methodProperty.writeViewBuilder(writer, this.shortName);
        }
        writer.append("    builder.endObject();").eol();
        writer.append("  }").eol();
    }

    @Override
    public void writeToJson(Append writer) {
        try {
            String varName = Util.initLower(this.shortName);
            writer.eol();
            writer.append("  @Override").eol();
            writer.append("  public void toJson(JsonWriter writer, %s %s) {", this.shortName, varName).eol();
            writer.append("    writer.beginObject(names);").eol();
            if (this.hasSubTypes) {
                this.writeToJsonForSubtypes(writer, varName);
            } else {
                this.writeToJsonForType(writer, varName, "    ", null);
            }
            writer.append("    writer.endObject();").eol();
            writer.append("  }").eol();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error writing toJson() on " + this.type, e);
        }
    }

    private void writeToJsonForSubtypes(Append writer, String varName) {
        if (this.hasSubTypes) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                TypeSubTypeMeta subTypeMeta = this.subTypes.get(i);
                String subType = subTypeMeta.type();
                String subTypeName = subTypeMeta.name();
                String elseIf = i == 0 ? "if" : "else if";
                String subTypeShort = Util.shortType(subTypeMeta.type());
                if (useInstanceofPattern) {
                    writer.append("    %s (%s instanceof final %s sub) {", elseIf, varName, subTypeShort).eol();
                } else {
                    writer.append("    %s (%s instanceof %s) {", elseIf, varName, subTypeShort).eol();
                    writer.append("      %s sub = (%s) %s;", subTypeShort, subTypeShort, varName).eol();
                }
                writer.append("      writer.name(0);").eol();
                writer.append("      stringJsonAdapter.toJson(writer, \"%s\");", subTypeName).eol();
                this.writeToJsonForType(writer, "sub", "      ", subType);
                writer.append("    }").eol();
            }
        }
    }

    private void writeToJsonForType(Append writer, String varName, String prefix, String type) {
        for (FieldReader allField : this.allFields) {
            if (this.usesTypeProperty && allField.propertyName().equals(this.typePropertyKey()) || !allField.includeToJson(type)) continue;
            allField.writeToJson(writer, varName, prefix);
        }
        for (MethodProperty methodProperty : this.methodProperties) {
            methodProperty.writeToJson(writer, varName, prefix);
        }
    }

    @Override
    public void writeFromJson(Append writer) {
        String varName = Util.initLower(this.shortName);
        writer.eol();
        writer.append("  @Override").eol();
        writer.append("  public %s fromJson(JsonReader reader) {", this.shortName, varName).eol();
        if (this.readOnlyInterface) {
            if (this.implementation == null) {
                writer.append("    throw new UnsupportedOperationException();").eol();
                writer.append("  }").eol();
            } else {
                this.implementation.writeFromJsonImplementation(writer, varName);
            }
            return;
        }
        this.writeFromJsonImplementation(writer, varName);
    }

    private void writeFromJsonImplementation(Append writer, String varName) {
        boolean directLoad;
        boolean bl = directLoad = this.constructor == null && !this.hasSubTypes && !this.optional;
        if (directLoad) {
            writer.append("    %s _$%s = new %s();", this.shortName, varName, this.shortName).eol();
        } else {
            writer.append("    // variables to read json values into, constructor params don't need _set$ flags").eol();
            for (FieldReader allField : this.allFields) {
                if (this.isRecord) {
                    allField.writeFromJsonVariablesRecord(writer);
                    continue;
                }
                if (!allField.includeFromJson()) continue;
                allField.writeFromJsonVariables(writer);
            }
        }
        if (this.hasSubTypes && !this.usesTypeProperty) {
            writer.eol().append("    String type = null;").eol();
        }
        if (this.unmappedField != null) {
            writer.append("    Map<String, Object> unmapped = new LinkedHashMap<>();").eol();
        }
        this.writeFromJsonSwitch(writer, directLoad, varName);
        writer.eol();
        if (this.hasSubTypes) {
            this.writeFromJsonWithSubTypes(writer);
            return;
        }
        if (!directLoad) {
            this.writeJsonBuildResult(writer, varName);
        } else if (this.unmappedField != null) {
            writer.append("   // unmappedField... ", varName).eol();
            this.unmappedField.writeFromJsonUnmapped(writer, varName);
        }
        writer.append("    return _$%s;", varName).eol();
        writer.append("  }").eol();
    }

    private void writeJsonBuildResult(Append writer, String varName) {
        writer.append("    // build and return %s", this.shortName).eol();
        writer.append("    %s _$%s = new %s(", this.shortName, varName, this.shortName);
        if (this.constructor != null) {
            List<MethodReader.MethodParam> params = this.constructor.getParams();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                Integer frequency;
                String name;
                if (i > 0) {
                    writer.append(", ");
                }
                writer.append(this.constructorParamName(name + ((frequency = this.frequencyMap.compute(name = params.get(i).name(), (k, v) -> v == null ? 0 : v + 1)) == 0 ? "" : frequency.toString())));
            }
        }
        writer.append(");").eol();
        for (FieldReader allField : this.allFields) {
            if (!allField.includeFromJson()) continue;
            this.frequencyMap.compute(allField.fieldName(), (k, v) -> v == null ? 0 : v + 1);
            allField.writeFromJsonSetter(writer, varName, "");
        }
    }

    private void writeFromJsonWithSubTypes(Append writer) {
        boolean useSwitch;
        String typeVar = this.usesTypeProperty ? "_val$" + this.typePropertyKey() : "type";
        boolean bl = useSwitch = this.subTypes.size() >= 3;
        if (!useSwitch || !nullSwitch) {
            writer.append("    if (%s == null) {", typeVar).eol();
            writer.append("      throw new IllegalStateException(\"Missing Required %s property that determines deserialization type\");", this.typeProperty).eol();
            writer.append("    }").eol();
        }
        if (useSwitch) {
            if (ProcessingContext.useEnhancedSwitch()) {
                writer.append("    return switch (%s) {", typeVar).eol();
            } else {
                writer.append("    switch (%s) {", typeVar).eol();
            }
            if (nullSwitch) {
                writer.append("      case null -> ").append("throw new IllegalStateException(\"Missing Required %s property that determines deserialization type\");", this.typeProperty).eol();
            }
        }
        HashMap<String, Integer> frequencyMap2 = new HashMap<String, Integer>();
        SubTypeRequest req = new SubTypeRequest(typeVar, this, useSwitch, this.useEnum, frequencyMap2, this.isCommonFieldMap);
        for (TypeSubTypeMeta subTypeMeta : this.subTypes) {
            String varName = Util.initLower(Util.shortName(subTypeMeta.type()));
            subTypeMeta.writeFromJsonBuild(writer, varName, req);
        }
        if (useSwitch) {
            writer.append("      default").appendSwitchCase().eol().append("    ");
        }
        writer.append("    throw new IllegalStateException(\"Unknown value for %s property \" + %s);", this.typeProperty, typeVar).eol();
        if (useSwitch) {
            if (ProcessingContext.useEnhancedSwitch()) {
                writer.append("        }").eol();
                writer.append("    };").eol();
            } else {
                writer.append("    }").eol();
            }
        }
        writer.append("  }").eol();
    }

    String constructorParamName(String name) {
        if (this.unmappedField != null && this.unmappedField.fieldName().equals(name)) {
            return "unmapped";
        }
        return "_val$" + name;
    }

    private void writeFromJsonSwitch(Append writer, boolean defaultConstructor, String varName) {
        String unmappedFieldName;
        writer.eol();
        writer.append("    // read json").eol();
        writer.append("    reader.beginObject(names);").eol();
        writer.append("    while (reader.hasNextField()) {").eol();
        if (this.caseInsensitiveKeys) {
            writer.append("      final String origFieldName = reader.nextField();").eol();
            writer.append("      final String fieldName = origFieldName.toLowerCase();").eol();
        } else {
            writer.append("      final String fieldName = reader.nextField();").eol();
        }
        writer.append("      switch (fieldName) {").eol();
        if (this.hasSubTypes && !this.usesTypeProperty) {
            writer.append("        case \"%s\":", this.typePropertyKey()).eol();
            writer.append("          type = stringJsonAdapter.fromJson(reader);").eol();
            writer.append("          break;").eol();
        }
        HashSet<String> seen = new HashSet<String>();
        for (FieldReader allField : this.allFields) {
            String name = allField.fieldName();
            if (!seen.add(name)) continue;
            if (this.hasSubTypes) {
                Boolean isCommonFieldDiffType = this.isCommonFieldMap.get(name);
                if (isCommonFieldDiffType == null || !isCommonFieldDiffType.booleanValue()) {
                    allField.writeFromJsonSwitch(writer, defaultConstructor, varName, this.caseInsensitiveKeys, this.allFields.stream().filter(x -> x.fieldName().equals(name)).flatMap(f -> f.aliases().stream()).collect(Collectors.toList()));
                    continue;
                }
                this.writeSubTypeCase(name, writer, this.allFields.stream().filter(x -> x.fieldName().equals(name)).collect(Collectors.toList()), defaultConstructor, varName);
                continue;
            }
            allField.writeFromJsonSwitch(writer, defaultConstructor, varName, this.caseInsensitiveKeys, List.of());
        }
        writer.append("        default:").eol();
        String string = unmappedFieldName = this.caseInsensitiveKeys ? "origFieldName" : "fieldName";
        if (this.unmappedField != null) {
            writer.append("          Object value = objectJsonAdapter.fromJson(reader);").eol();
            writer.append("          unmapped.put(%s, value);", unmappedFieldName).eol();
        } else {
            writer.append("          reader.unmappedField(%s);", unmappedFieldName).eol();
            writer.append("          reader.skipValue();").eol();
        }
        writer.append("      }").eol();
        writer.append("    }").eol();
        writer.append("    reader.endObject();").eol();
    }

    private void writeSubTypeCase(String name, Append writer, List<FieldReader> commonFields, boolean defaultConstructor, String varName) {
        writer.append("        case \"%s\":", name).eol();
        for (String alias : commonFields.stream().map(FieldReader::aliases).findFirst().orElseGet(List::of)) {
            String propertyKey = this.caseInsensitiveKeys ? alias.toLowerCase() : alias;
            writer.append("        case \"%s\":", propertyKey).eol();
        }
        boolean elseIf = false;
        for (FieldReader fieldReader : commonFields) {
            TypeSubTypeMeta subtype = new ArrayList<TypeSubTypeMeta>(fieldReader.subTypes().values()).get(0);
            MethodReader setter = fieldReader.setter();
            String adapterFieldName = fieldReader.adapterFieldName();
            String fieldName = fieldReader.fieldNameWithNum();
            if (this.useEnum) {
                writer.append("          %sif (%s.equals(%s)) {", elseIf ? "else " : "", subtype.name(), "type").eol();
            } else {
                writer.append("          %sif (\"%s\".equals(%s)) {", elseIf ? "else " : "", subtype.name(), "type").eol();
            }
            elseIf = true;
            if (!fieldReader.isDeserialize()) {
                writer.append("            reader.skipValue();");
            } else if (defaultConstructor) {
                if (setter != null) {
                    writer.append("            _$%s.%s(%s.fromJson(reader));", varName, setter.getName(), adapterFieldName);
                } else if (fieldReader.isPublicField()) {
                    writer.append("            _$%s.%s = %s.fromJson(reader);", varName, fieldName, adapterFieldName);
                }
            } else {
                writer.append("            _val$%s = %s.fromJson(reader);", fieldName, adapterFieldName);
                if (!fieldReader.isConstructorParam()) {
                    writer.eol().append("            _set$%s = true;", fieldName);
                }
            }
            writer.eol().append("          }").eol();
        }
        writer.append("          else {").eol().append("            throw new IllegalStateException(\"Missing Required type3 property that determines deserialization type\");").eol().append("          }").eol().append("          break;").eol().eol();
    }

    private String typePropertyKey() {
        return this.caseInsensitiveKeys ? this.typeProperty.toLowerCase() : this.typeProperty;
    }
}

