/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Util;
import javax.lang.model.element.TypeElement;

final class AdapterName {
    final String shortName;
    final String adapterPackage;
    final String fullName;

    AdapterName(TypeElement origin) {
        String originName = origin.getQualifiedName().toString();
        String name = origin.getSimpleName().toString();
        String originPackage = Util.packageOf(originName);
        if (origin.getNestingKind().isNested()) {
            String parent = Util.shortName(originPackage);
            originPackage = Util.packageOf(originPackage);
            this.shortName = parent + "$" + name;
        } else {
            this.shortName = name;
        }
        this.adapterPackage = "".equals(originPackage) ? "jsonb" : originPackage + ".jsonb";
        this.fullName = this.adapterPackage + "." + this.shortName + "JsonAdapter";
    }

    String shortName() {
        return this.shortName;
    }

    String adapterPackage() {
        return this.adapterPackage;
    }

    String fullName() {
        return this.fullName;
    }
}

