/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.FieldReader;
import io.avaje.jsonb.generator.MethodReader;
import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.SubTypePrism;
import io.avaje.jsonb.generator.SubTypeRequest;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;

final class TypeSubTypeMeta {
    private final String type;
    private String name;
    private final String shortType;
    private TypeElement typeElement;
    private boolean defaultPublicConstructor;
    private final List<MethodReader> publicConstructors = new ArrayList<MethodReader>();
    private final Set<String> constructorFieldNames = new LinkedHashSet<String>();

    public String toString() {
        return this.type;
    }

    TypeSubTypeMeta(SubTypePrism prism) {
        this.type = prism.type().toString();
        this.name = Util.escapeQuotes(prism.name());
        this.shortType = Util.shortType(this.type);
    }

    void setElement(TypeElement element) {
        this.typeElement = element;
    }

    TypeElement element() {
        return this.typeElement;
    }

    String type() {
        return this.type;
    }

    String name() {
        if (this.name.isBlank()) {
            this.name = Util.shortType(this.type);
        }
        return this.name;
    }

    void addConstructor(MethodReader methodReader) {
        if (methodReader.getParams().isEmpty()) {
            this.defaultPublicConstructor = true;
        }
        this.publicConstructors.add(methodReader);
    }

    void writeFromJsonBuild(Append writer, String varName, SubTypeRequest req) {
        if (req.useSwitch()) {
            if (req.useEnum()) {
                writer.append("      case %s", this.name()).appendSwitchCase().eol();
            } else {
                writer.append("      case \"%s\"", this.name()).appendSwitchCase().eol();
            }
            writer.append("  ");
            this.writeFromJsonConstructor(writer, varName, req);
            this.writeFromJsonSetters(writer, varName, req);
            if (ProcessingContext.useEnhancedSwitch()) {
                writer.append("        yield _$%s;", varName).eol();
                writer.append("      }").eol();
            } else {
                writer.append("        return _$%s;", varName).eol();
            }
        } else {
            if (req.useEnum()) {
                writer.append("    if (%s.equals(%s)) {", this.name(), req.typeVar()).eol();
            } else {
                writer.append("    if (\"%s\".equals(%s)) {", this.name(), req.typeVar()).eol();
            }
            this.writeFromJsonConstructor(writer, varName, req);
            this.writeFromJsonSetters(writer, varName, req);
            writer.append("      return _$%s;", varName).eol();
            writer.append("    }").eol();
        }
    }

    private void writeFromJsonSetters(Append writer, String varName, SubTypeRequest req) {
        for (FieldReader field : req.beanReader().allFields()) {
            if (!this.isIncludeSetter(field)) continue;
            if (req.useSwitch()) {
                writer.append("  ");
            }
            field.writeFromJsonSetter(writer, varName, "  ");
        }
    }

    private boolean isIncludeSetter(FieldReader field) {
        return field.includeFromJson() && !this.constructorFieldNames.contains(field.fieldName()) && field.includeForType(this);
    }

    private void writeFromJsonConstructor(Append writer, String varName, SubTypeRequest req) {
        writer.append("      %s _$%s = new %s(", this.shortType, varName, this.shortType);
        MethodReader constructor = this.findConstructor();
        if (constructor != null) {
            List<MethodReader.MethodParam> params = constructor.getParams();
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                MethodReader.MethodParam param = params.get(i);
                String paramName = param.name();
                this.constructorFieldNames.add(paramName);
                Object constructParamName = req.beanReader().constructorParamName(paramName);
                if (((String)constructParamName).startsWith("_val$") && req.isCommonField(paramName)) {
                    String frequencySuffix = req.frequencySuffix((String)constructParamName);
                    constructParamName = (String)constructParamName + frequencySuffix;
                }
                writer.append((String)constructParamName);
            }
        }
        writer.append(");").eol();
    }

    private MethodReader findConstructor() {
        if (this.defaultPublicConstructor || this.publicConstructors.isEmpty()) {
            return null;
        }
        return this.publicConstructors.get(0);
    }
}

