/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ClassReader;
import java.util.Map;

final class SubTypeRequest {
    private final String typeVar;
    private final ClassReader beanReader;
    private final boolean useSwitch;
    private final boolean useEnum;
    private final Map<String, Integer> frequencyMap;
    private final Map<String, Boolean> commonFieldMap;

    SubTypeRequest(String typeVar, ClassReader beanReader, boolean useSwitch, boolean useEnum, Map<String, Integer> frequencyMap, Map<String, Boolean> commonFieldMap) {
        this.typeVar = typeVar;
        this.beanReader = beanReader;
        this.useSwitch = useSwitch;
        this.useEnum = useEnum;
        this.frequencyMap = frequencyMap;
        this.commonFieldMap = commonFieldMap;
    }

    String typeVar() {
        return this.typeVar;
    }

    ClassReader beanReader() {
        return this.beanReader;
    }

    boolean useSwitch() {
        return this.useSwitch;
    }

    boolean useEnum() {
        return this.useEnum;
    }

    boolean isCommonField(String paramName) {
        return Boolean.TRUE.equals(this.commonFieldMap.get(paramName));
    }

    String frequencySuffix(String constructParamName) {
        Integer frequency = this.frequencyMap.compute(constructParamName, (k, v) -> v == null ? 0 : v + 1);
        return frequency == 0 ? "" : frequency.toString();
    }
}

