/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.ProcessingContext;
import io.avaje.jsonb.generator.TypeSubTypeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

class TypeSubTypeReader {
    private static final String JSON_SUBTYPE = "io.avaje.jsonb.Json.SubType";
    private static final String JSON_SUBTYPES = "io.avaje.jsonb.Json.SubTypes";
    private final TypeElement baseType;
    private final ProcessingContext context;
    private final List<TypeSubTypeMeta> subTypes = new ArrayList<TypeSubTypeMeta>();

    TypeSubTypeReader(TypeElement baseType, ProcessingContext context) {
        this.baseType = baseType;
        this.context = context;
        this.read();
    }

    List<TypeSubTypeMeta> subTypes() {
        return this.subTypes;
    }

    boolean hasSubTypes() {
        return !this.subTypes.isEmpty();
    }

    void read() {
        for (AnnotationMirror annotationMirror : this.baseType.getAnnotationMirrors()) {
            String annType = annotationMirror.getAnnotationType().toString();
            if (JSON_SUBTYPE.equals(annType)) {
                this.readSubType(annotationMirror);
                continue;
            }
            if (!JSON_SUBTYPES.equals(annType)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                for (Object importType : (List)entry.getValue().getValue()) {
                    this.readSubType((AnnotationMirror)importType);
                }
            }
        }
    }

    private void readSubType(AnnotationMirror mirror) {
        TypeSubTypeMeta meta = new TypeSubTypeMeta();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            meta.add(key, val);
        }
        this.subTypes.add(meta);
    }
}

