/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.AdapterName;
import io.avaje.jsonb.generator.Append;
import io.avaje.jsonb.generator.BeanReader;
import io.avaje.jsonb.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import javax.tools.JavaFileObject;

class SimpleAdapterWriter {
    private final BeanReader beanReader;
    private final ProcessingContext context;
    private final String adapterShortName;
    private final String adapterPackage;
    private final String adapterFullName;
    private Append writer;

    SimpleAdapterWriter(BeanReader beanReader, ProcessingContext context) {
        this.beanReader = beanReader;
        this.context = context;
        AdapterName adapterName = new AdapterName(beanReader.getBeanType());
        this.adapterShortName = adapterName.shortName();
        this.adapterPackage = adapterName.adapterPackage();
        this.adapterFullName = adapterName.fullName();
    }

    String fullName() {
        return this.adapterFullName;
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.context.createWriter(this.adapterFullName);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeFields();
        this.writeConstructor();
        this.writeToFromJson();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeConstructor() {
        this.writer.append("  public %sJsonAdapter(Jsonb jsonb) {", this.adapterShortName).eol();
        this.beanReader.writeConstructor(this.writer);
        this.writer.append("  }").eol();
    }

    private void writeToFromJson() {
        this.beanReader.writeViewSupport(this.writer);
        this.beanReader.writeToJson(this.writer);
        this.beanReader.writeFromJson(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        this.writer.append("public class %sJsonAdapter extends JsonAdapter<%s> ", this.adapterShortName, this.beanReader.shortName());
        if (!this.beanReader.hasSubtypes()) {
            this.writer.append("implements ViewBuilderAware ");
        }
        this.writer.append("{").eol().eol();
    }

    private void writeFields() {
        this.beanReader.writeFields(this.writer);
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void writePackage() {
        this.writer.append("package %s;", this.adapterPackage).eol().eol();
    }
}

