/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

class PropertyIgnoreReader {
    private static final String JSON_IGNORE = "io.avaje.jsonb.Json.Ignore";
    private static final String JSON_UNMAPPED = "io.avaje.jsonb.Json.Unmapped";
    private boolean unmapped;
    private boolean ignoreSerialize;
    private boolean ignoreDeserialize;

    PropertyIgnoreReader(Element element) {
        this.read(element);
    }

    boolean unmapped() {
        return this.unmapped;
    }

    boolean serialize() {
        return !this.ignoreSerialize;
    }

    boolean deserialize() {
        return !this.ignoreDeserialize;
    }

    void read(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (JSON_UNMAPPED.equals(annotationMirror.getAnnotationType().toString())) {
                this.unmapped = true;
                continue;
            }
            if (!JSON_IGNORE.equals(annotationMirror.getAnnotationType().toString())) continue;
            this.ignoreDeserialize = true;
            this.ignoreSerialize = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (key.equals("deserialize()")) {
                    this.ignoreDeserialize = "false".equals(value);
                    continue;
                }
                if (key.equals("serialize()")) {
                    this.ignoreSerialize = "false".equals(value);
                    continue;
                }
                throw new IllegalStateException("Unknown attribute on @Json.Ignore " + key);
            }
        }
    }
}

