/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jsonb.generator;

import io.avaje.jsonb.generator.TopPackage;
import io.avaje.jsonb.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

class ComponentMetaData {
    private final List<String> allTypes = new ArrayList<String>();
    private String fullName;

    ComponentMetaData() {
    }

    public String toString() {
        return this.allTypes.toString();
    }

    void initialiseFullName() {
        this.fullName();
    }

    boolean contains(String type) {
        return this.allTypes.contains(type);
    }

    void add(String type) {
        this.allTypes.add(type);
    }

    void setFullName(String fullName) {
        this.fullName = fullName;
    }

    String fullName() {
        if (this.fullName == null) {
            String topPackage = TopPackage.of(this.allTypes);
            if (!topPackage.endsWith(".jsonb")) {
                topPackage = topPackage + ".jsonb";
            }
            this.fullName = topPackage + ".GeneratedJsonComponent";
        }
        return this.fullName;
    }

    String packageName() {
        return Util.packageOf(this.fullName());
    }

    List<String> all() {
        return this.allTypes;
    }

    Collection<String> allImports() {
        TreeSet<String> packageImports = new TreeSet<String>();
        for (String adapterFullName : this.allTypes) {
            packageImports.add(Util.packageOf(adapterFullName) + ".*");
            packageImports.add(Util.baseTypeOfAdapter(adapterFullName));
        }
        return packageImports;
    }
}

