/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.spi;

import io.avaje.jex.spi.ClassResourceLoader;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;

final class DResourceLoader
implements ClassResourceLoader {
    private final Class<?> clazz;

    DResourceLoader(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public URL loadResource(String resourcePath) {
        String path = Objects.requireNonNull(resourcePath).transform(this::prependSlash);
        URL url = this.clazz.getResource(path);
        if (url == null) {
            url = Optional.ofNullable(ClassLoader.getSystemResource(path)).orElseGet(() -> Thread.currentThread().getContextClassLoader().getResource(path));
        }
        return Objects.requireNonNull(url, "Unable to locate resource: " + path);
    }

    private String prependSlash(String s) {
        return s.charAt(0) == '/' ? s : "/" + s;
    }
}

