/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.applog.AppLog;
import io.avaje.jex.Routing;
import io.avaje.jex.http.HttpFilter;
import io.avaje.jex.routes.RouteIndex;
import io.avaje.jex.routes.SpiRoutes;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

final class Routes
implements SpiRoutes {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");
    private final EnumMap<Routing.Type, RouteIndex> typeMap;
    private final List<HttpFilter> filters;
    private final AtomicLong noRouteCounter = new AtomicLong();

    Routes(EnumMap<Routing.Type, RouteIndex> typeMap, List<HttpFilter> filters) {
        this.typeMap = typeMap;
        this.filters = filters;
    }

    public String toString() {
        return "Routes{" + String.valueOf(this.typeMap) + ", filters=" + String.valueOf(this.filters) + "}";
    }

    @Override
    public void inc() {
        this.noRouteCounter.incrementAndGet();
    }

    @Override
    public void dec() {
        this.noRouteCounter.decrementAndGet();
    }

    @Override
    public long activeRequests() {
        long total = this.noRouteCounter.get();
        for (RouteIndex value : this.typeMap.values()) {
            total += value.activeRequests();
        }
        return total;
    }

    @Override
    public void waitForIdle(long maxSeconds) {
        log.log(System.Logger.Level.DEBUG, "stopping server with maxWaitSeconds {0}", maxSeconds);
        this.maxWaitAttempts(maxSeconds * 20L);
        this.park50Millis();
        if (!this.maxWaitAttempts(5L)) {
            log.log(System.Logger.Level.WARNING, "Active requests still in process");
        }
    }

    private boolean maxWaitAttempts(long maxAttempts) {
        long attempts = 0L;
        while (this.activeRequests() > 0L && ++attempts < maxAttempts) {
            this.park50Millis();
        }
        return attempts < maxAttempts;
    }

    private void park50Millis() {
        LockSupport.parkNanos(50000000L);
    }

    @Override
    public SpiRoutes.Entry match(Routing.Type type, String pathInfo) {
        return this.typeMap.get((Object)type).match(pathInfo);
    }

    @Override
    public List<HttpFilter> filters() {
        return this.filters;
    }
}

