/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.http.sse;

import io.avaje.applog.AppLog;
import io.avaje.jex.http.Context;
import io.avaje.jex.http.sse.Emitter;
import io.avaje.jex.http.sse.SseClient;
import io.avaje.jex.spi.JsonService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

final class SseClientImpl
implements SseClient {
    private static final System.Logger log = AppLog.getLogger((String)SseClient.class.getCanonicalName());
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final Emitter emitter;
    private final JsonService jsonService;
    private final Context ctx;
    private CompletableFuture<?> blockingFuture;
    private Runnable closeCallback = () -> {};

    SseClientImpl(Context ctx) {
        this.emitter = new Emitter(ctx.exchange().getResponseBody());
        this.jsonService = ctx.jsonService();
        this.ctx = ctx;
    }

    @Override
    public void onClose(Runnable task) {
        this.closeCallback = task;
    }

    @Override
    public void close() {
        if (this.terminated.getAndSet(true)) {
            return;
        }
        this.closeCallback.run();
        if (this.blockingFuture != null) {
            this.blockingFuture.complete(null);
        }
    }

    @Override
    public Context ctx() {
        return this.ctx;
    }

    @Override
    public void keepAlive() {
        if (this.terminated.get()) {
            return;
        }
        this.blockingFuture = new CompletableFuture();
        this.blockingFuture.join();
    }

    private void logTerminated() {
        log.log(System.Logger.Level.WARNING, "Cannot send data, SseClient has been terminated.");
    }

    @Override
    public void sendComment(String comment) {
        if (this.terminated.get()) {
            this.logTerminated();
            return;
        }
        this.emitter.emit(comment);
        if (this.emitter.isClosed()) {
            this.close();
        }
    }

    @Override
    public void sendEvent(Object data) {
        this.sendEvent("message", data);
    }

    @Override
    public void sendEvent(String event, Object data) {
        this.sendEvent(event, data, null);
    }

    @Override
    public void sendEvent(String event, Object data, String id) {
        if (this.terminated.get()) {
            this.logTerminated();
            return;
        }
        Object object = data;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        InputStream inputStream = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InputStream.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                InputStream is = (InputStream)object2;
                yield is;
            }
            case 1 -> {
                String s = (String)object2;
                yield new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
            }
            default -> new ByteArrayInputStream(this.jsonService.toJsonString(data).getBytes(StandardCharsets.UTF_8));
        };
        this.emitter.emit(event, inputStream, id);
        if (this.emitter.isClosed()) {
            this.close();
        }
    }

    @Override
    public boolean terminated() {
        return this.terminated.get();
    }
}

