/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.sun.net.httpserver.HttpServer;
import io.avaje.applog.AppLog;
import io.avaje.jex.AppLifecycle;
import io.avaje.jex.Jex;
import io.avaje.jex.core.RoutingHandler;

final class JdkJexServer
implements Jex.Server {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.jex");
    private final HttpServer server;
    private final AppLifecycle lifecycle;
    private final RoutingHandler handler;

    JdkJexServer(HttpServer server, AppLifecycle lifecycle, RoutingHandler handler) {
        this.server = server;
        this.lifecycle = lifecycle;
        this.handler = handler;
        lifecycle.registerShutdownHook(this::shutdown);
    }

    @Override
    public void onShutdown(Runnable onShutdown) {
        this.lifecycle.onShutdown(onShutdown, Integer.MAX_VALUE);
    }

    @Override
    public void shutdown() {
        log.log(System.Logger.Level.TRACE, "starting shutdown");
        this.lifecycle.status(AppLifecycle.Status.STOPPING);
        this.handler.waitForIdle(30L);
        this.server.stop(0);
        log.log(System.Logger.Level.TRACE, "server http listeners stopped");
        this.lifecycle.status(AppLifecycle.Status.STOPPED);
    }

    @Override
    public int port() {
        return this.server.getAddress().getPort();
    }
}

