/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.core.JdkContext;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

final class BufferedOutStream
extends FilterOutputStream {
    private final long max;
    private final JdkContext context;
    private ByteArrayOutputStream buffer;
    private boolean jdkOutput;
    private long count;

    BufferedOutStream(JdkContext context, int initial, long max) {
        super(context.exchange().getResponseBody());
        this.context = context;
        this.max = max;
        if (context.responseHeader("Content-length") != null) {
            this.count = max + 1L;
        } else {
            this.buffer = new ByteArrayOutputStream(initial);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.jdkOutput) {
            this.out.write(b);
        } else {
            if (this.count++ > this.max) {
                this.useJdkOutput();
                this.out.write(b);
                return;
            }
            this.buffer.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.jdkOutput) {
            this.out.write(b, off, len);
        } else {
            this.count += (long)len;
            if (this.count > this.max) {
                this.useJdkOutput();
                this.out.write(b, off, len);
                return;
            }
            this.buffer.write(b, off, len);
        }
    }

    private void useJdkOutput() throws IOException {
        String length = this.context.responseHeader("Content-length");
        this.context.exchange().sendResponseHeaders(this.context.statusCode(), length == null ? 0L : Long.parseLong(length));
        this.jdkOutput = true;
        if (this.buffer != null) {
            this.buffer.writeTo(this.out);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jdkOutput) {
            this.out.close();
        } else {
            this.context.write(this.buffer.toByteArray());
        }
    }
}

