/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.JexConfig;
import io.avaje.jex.Routing;
import io.avaje.jex.http.HttpFilter;
import io.avaje.jex.routes.PathParser;
import io.avaje.jex.routes.RouteEntry;
import io.avaje.jex.routes.RouteIndex;
import io.avaje.jex.routes.RouteIndexBuild;
import io.avaje.jex.routes.Routes;
import io.avaje.jex.routes.SpiRoutes;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class RoutesBuilder {
    private final EnumMap<Routing.Type, RouteIndex> typeMap = new EnumMap(Routing.Type.class);
    private final boolean ignoreTrailingSlashes;
    private final List<HttpFilter> filters;
    private final String contextPath;

    public RoutesBuilder(Routing routing, JexConfig config) {
        this.ignoreTrailingSlashes = config.ignoreTrailingSlashes();
        LinkedHashMap<Routing.Type, RouteIndexBuild> buildMap = new LinkedHashMap<Routing.Type, RouteIndexBuild>();
        this.contextPath = config.contextPath().transform(s -> "/".equals(s) ? "" : s);
        for (Routing.Entry handler : routing.handlers()) {
            buildMap.computeIfAbsent(handler.getType(), h -> new RouteIndexBuild()).add(this.convert(handler));
        }
        buildMap.forEach((key, value) -> this.typeMap.put((Routing.Type)((Object)key), value.build()));
        this.filters = List.copyOf(routing.filters());
    }

    private SpiRoutes.Entry convert(Routing.Entry handler) {
        PathParser pathParser = new PathParser(this.contextPath + handler.getPath(), this.ignoreTrailingSlashes);
        return new RouteEntry(pathParser, handler.getHandler(), handler.getRoles());
    }

    public SpiRoutes build() {
        return new Routes(this.typeMap, this.filters);
    }
}

