/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.routes.PathSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

final class PathSegmentParser {
    private static final PathSegment WILDCARD = new PathSegment.Wildcard();
    private static final String[] ADJACENT_VIOLATIONS = new String[]{"*{", "*<", "}*", ">*"};
    private static final String NAME_STR = "[\\w-]+";
    private static final String NAME_OPT = "(:[^/^{]+([{]\\d+})?)?";
    private static final String SLASH_STR = "<[\\w-]+>";
    private static final String PARAM_STR = "[{][\\w-]+(:[^/^{]+([{]\\d+})?)?}";
    private static final String MULTI_STR = "([{][\\w-]+(:[^/^{]+([{]\\d+})?)?}|<[\\w-]+>|[*]|[^{</*]+)";
    private static final Pattern MATCH_PARAM = Pattern.compile("[{][\\w-]+(:[^/^{]+([{]\\d+})?)?}");
    private static final Pattern MATCH_MULTI = Pattern.compile("([{][\\w-]+(:[^/^{]+([{]\\d+})?)?}|<[\\w-]+>|[*]|[^{</*]+)");
    private final String segment;
    private final String rawPath;

    PathSegmentParser(String segment, String rawPath) {
        this.segment = segment;
        this.rawPath = rawPath;
    }

    static PathSegment parse(String seg, String rawPath) {
        if ("*".equals(seg)) {
            return WILDCARD;
        }
        return new PathSegmentParser(seg, rawPath).parse();
    }

    PathSegment parse() {
        this.checkAdjacentViolations();
        if (this.matchOnlyStartEnd('<', '>')) {
            return new PathSegment.SlashAcceptingParameter(this.trim(this.segment));
        }
        if (this.matchOnlyStartEnd('{', '}') || PathSegmentParser.matchParamWithRegex(this.segment)) {
            return new PathSegment.SlashIgnoringParameter(this.trim(this.segment));
        }
        if (PathSegmentParser.matchLiteral(this.segment)) {
            return new PathSegment.Literal(this.segment);
        }
        return this.parseMultiSegment();
    }

    private PathSegment parseMultiSegment() {
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>();
        List<String> tokens = PathSegmentParser.multi(this.segment);
        int position = 0;
        StringBuilder appendedTokens = new StringBuilder(this.segment.length());
        for (String token : tokens) {
            appendedTokens.append(token);
            if (!this.segment.startsWith(appendedTokens.toString())) {
                throw new IllegalArgumentException("Path [" + this.rawPath + "] has illegal segment [" + this.segment + "] starting at position [" + position + "]");
            }
            position += token.length();
            segments.add(this.tokenSegment(token));
        }
        return new PathSegment.Multi(segments);
    }

    private PathSegment tokenSegment(String token) {
        if ("*".equals(token)) {
            return WILDCARD;
        }
        if (token.charAt(0) == '<') {
            return this.slashAccepting(token);
        }
        if (token.charAt(0) == '{') {
            return this.slashIgnoring(token);
        }
        return new PathSegment.Literal(token);
    }

    private PathSegment slashIgnoring(String token) {
        return new PathSegment.SlashIgnoringParameter(this.trim(token));
    }

    private PathSegment slashAccepting(String token) {
        return new PathSegment.SlashAcceptingParameter(this.trim(token));
    }

    static boolean matchParamWithRegex(String input) {
        return MATCH_PARAM.matcher(input).matches();
    }

    static List<String> multi(String input) {
        return MATCH_MULTI.matcher(input).results().map(MatchResult::group).toList();
    }

    static boolean matchLiteral(String segment) {
        return segment.indexOf(60) == -1 && segment.indexOf(123) == -1 && segment.indexOf(62) == -1 && segment.indexOf(125) == -1;
    }

    private void checkAdjacentViolations() {
        for (String adjacentViolation : ADJACENT_VIOLATIONS) {
            if (!this.segment.contains(adjacentViolation)) continue;
            throw new IllegalArgumentException("Path [" + this.rawPath + "] has illegal segment [" + this.segment + "] that contains [" + adjacentViolation + "]");
        }
    }

    private String trim(String token) {
        return token.substring(1, token.length() - 1);
    }

    boolean matchOnlyStartEnd(char startChar, char endChar) {
        return this.startCharOnly(startChar) && this.endCharOnly(endChar);
    }

    boolean startCharOnly(char c) {
        return this.segment.charAt(0) == c && this.segment.indexOf(c, 1) == -1;
    }

    boolean endCharOnly(char c) {
        return this.segment.indexOf(c) == this.segment.length() - 1;
    }
}

