/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import io.avaje.jex.core.CookieParser;
import io.avaje.jex.core.Mode;
import io.avaje.jex.core.ServiceManager;
import io.avaje.jex.http.Context;
import io.avaje.jex.http.HttpStatus;
import io.avaje.jex.http.RedirectException;
import io.avaje.jex.security.BasicAuthCredentials;
import io.avaje.jex.security.Role;
import io.avaje.jex.spi.JsonService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

final class JdkContext
implements Context {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE = "Cookie";
    private final ServiceManager mgr;
    private final String matchedPath;
    private final Map<String, String> pathParams;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Set<Role> roles;
    private final HttpExchange exchange;
    private Mode mode;
    private Map<String, List<String>> formParams;
    private Map<String, List<String>> queryParams;
    private Map<String, String> cookieMap;
    private int statusCode;
    private byte[] bodyBytes;
    private Charset characterEncoding;

    JdkContext(ServiceManager mgr, HttpExchange exchange, String path, Map<String, String> pathParams, Set<Role> roles) {
        this.mgr = mgr;
        this.roles = roles;
        this.exchange = exchange;
        this.matchedPath = path;
        this.pathParams = pathParams;
    }

    JdkContext(ServiceManager mgr, HttpExchange exchange, String path, Set<Role> roles) {
        this.mgr = mgr;
        this.roles = roles;
        this.exchange = exchange;
        this.matchedPath = path;
        this.pathParams = null;
    }

    @Override
    public <T> T attribute(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public Context attribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public BasicAuthCredentials basicAuthCredentials() {
        return JdkContext.getBasicAuthCredentials(this.header("Authorization"));
    }

    private static BasicAuthCredentials getBasicAuthCredentials(String authorizationHeader) {
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            return null;
        }
        String base64Credentials = authorizationHeader.substring("Basic ".length());
        byte[] decodedCredentials = Base64.getDecoder().decode(base64Credentials);
        String credentialsString = new String(decodedCredentials);
        String[] credentials = credentialsString.split(":", 2);
        if (credentials.length != 2) {
            throw new IllegalStateException("Invalid Basic Auth header");
        }
        return new BasicAuthCredentials(credentials[0], credentials[1]);
    }

    @Override
    public String body() {
        return new String(this.bodyAsBytes(), this.characterEncoding());
    }

    @Override
    public byte[] bodyAsBytes() {
        try {
            if (this.bodyBytes == null) {
                this.bodyBytes = this.exchange.getRequestBody().readAllBytes();
            }
            return this.bodyBytes;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InputStream bodyAsInputStream() {
        return this.exchange.getRequestBody();
    }

    @Override
    public <T> T bodyAsType(Type beanType) {
        return this.mgr.fromJson(beanType, this.bodyAsBytes());
    }

    @Override
    public <T> T bodyStreamAsType(Type beanType) {
        return this.bodyBytes == null ? this.mgr.fromJson(beanType, this.bodyAsInputStream()) : this.bodyAsType(beanType);
    }

    private Charset characterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = this.mgr.requestCharset(this);
        }
        return this.characterEncoding;
    }

    @Override
    public long contentLength() {
        String len = this.header("Content-length");
        return len == null ? 0L : Long.parseLong(len);
    }

    @Override
    public String contentType() {
        return this.header(this.exchange.getRequestHeaders(), "Content-type");
    }

    @Override
    public Context contentType(String contentType) {
        this.exchange.getResponseHeaders().set("Content-type", contentType);
        return this;
    }

    @Override
    public String contextPath() {
        return this.exchange.getHttpContext().getPath();
    }

    @Override
    public Context cookie(Context.Cookie cookie) {
        this.header(SET_COOKIE, cookie.toString());
        return this;
    }

    @Override
    public String cookie(String name) {
        return this.cookieMap().get(name);
    }

    @Override
    public Context cookie(String name, String value) {
        this.header(SET_COOKIE, Context.Cookie.of(name, value).toString());
        return this;
    }

    @Override
    public Context cookie(String name, String value, int maxAge) {
        this.header(SET_COOKIE, Context.Cookie.of(name, value).maxAge(Duration.ofSeconds(maxAge)).toString());
        return this;
    }

    @Override
    public Map<String, String> cookieMap() {
        if (this.cookieMap == null) {
            this.cookieMap = this.parseCookies();
        }
        return this.cookieMap;
    }

    @Override
    public HttpExchange exchange() {
        return this.exchange;
    }

    @Override
    public Map<String, List<String>> formParamMap() {
        if (this.formParams == null) {
            this.formParams = this.initFormParamMap();
        }
        return this.formParams;
    }

    private String header(Headers headers, String name) {
        return headers.getFirst(name);
    }

    @Override
    public String header(String key) {
        return this.header(this.exchange.getRequestHeaders(), key);
    }

    @Override
    public List<String> headerValues(String key) {
        return this.exchange.getRequestHeaders().get(key);
    }

    @Override
    public Context header(String key, List<String> value) {
        this.exchange.getResponseHeaders().put(key, value);
        return this;
    }

    @Override
    public Context header(String key, String value) {
        this.exchange.getResponseHeaders().add(key, value);
        return this;
    }

    @Override
    public Map<String, String> headerMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.exchange.getRequestHeaders().entrySet()) {
            List<String> value = entry.getValue();
            if (value.isEmpty()) continue;
            map.put(entry.getKey(), value.getFirst());
        }
        return map;
    }

    @Override
    public Context headerMap(Map<String, List<String>> map) {
        this.exchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)map);
        return this;
    }

    @Override
    public Headers requestHeaders() {
        return this.exchange.getRequestHeaders();
    }

    @Override
    public Headers responseHeaders() {
        return this.exchange.getResponseHeaders();
    }

    @Override
    public List<String> responseHeaderValues(String key) {
        return this.exchange.getResponseHeaders().get(key);
    }

    @Override
    public String host() {
        return this.header("Host");
    }

    @Override
    public void html(String content) {
        this.contentType("text/html;charset=utf-8");
        this.write(content);
    }

    private Map<String, List<String>> initFormParamMap() {
        return this.mgr.formParamMap(this, this.characterEncoding());
    }

    @Override
    public String ip() {
        InetSocketAddress remote = this.exchange.getRemoteAddress();
        if (remote == null) {
            return "";
        }
        InetAddress address = remote.getAddress();
        return address == null ? remote.getHostString() : address.getHostAddress();
    }

    @Override
    public void json(Object bean) {
        this.contentType("application/json");
        this.mgr.toJson(bean, this.outputStream());
    }

    @Override
    public <E> void jsonStream(Iterator<E> iterator) {
        this.contentType("application/x-json-stream");
        this.mgr.toJsonStream(iterator, this.outputStream());
    }

    @Override
    public <E> void jsonStream(Stream<E> stream) {
        this.contentType("application/x-json-stream");
        this.mgr.toJsonStream(stream, this.outputStream());
    }

    @Override
    public String matchedPath() {
        return this.matchedPath;
    }

    @Override
    public String method() {
        return this.exchange.getRequestMethod();
    }

    @Override
    public OutputStream outputStream() {
        return this.mgr.createOutputStream(this);
    }

    private Map<String, String> parseCookies() {
        String cookieHeader = this.header(this.exchange.getRequestHeaders(), COOKIE);
        if (cookieHeader == null || cookieHeader.isEmpty()) {
            return Collections.emptyMap();
        }
        return CookieParser.parse(cookieHeader);
    }

    @Override
    public String path() {
        return this.exchange.getRequestURI().getPath();
    }

    @Override
    public String pathParam(String name) {
        return this.pathParams.get(name);
    }

    @Override
    public Map<String, String> pathParamMap() {
        return this.pathParams;
    }

    public void performRedirect() {
        try {
            this.exchange.sendResponseHeaders(this.statusCode(), -1L);
            this.exchange.getResponseBody().close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int port() {
        return this.exchange.getLocalAddress().getPort();
    }

    @Override
    public String protocol() {
        return this.exchange.getProtocol();
    }

    @Override
    public String queryParam(String name) {
        List<String> vals = this.queryParams(name);
        return vals.isEmpty() ? null : vals.getFirst();
    }

    @Override
    public Map<String, String> queryParamMap() {
        Map<String, List<String>> map = this.queryParams();
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> single = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            single.put(entry.getKey(), value.getFirst());
        }
        return single;
    }

    private Map<String, List<String>> queryParams() {
        if (this.queryParams == null) {
            this.queryParams = this.mgr.parseParamMap(this.queryString(), StandardCharsets.UTF_8);
        }
        return this.queryParams;
    }

    @Override
    public List<String> queryParams(String name) {
        List<String> vals = this.queryParams().get(name);
        return vals == null ? Collections.emptyList() : vals;
    }

    @Override
    public String queryString() {
        return this.exchange.getRequestURI().getQuery();
    }

    @Override
    public void redirect(String location) {
        this.redirect(location, HttpStatus.FOUND_302.status());
    }

    @Override
    public void redirect(String location, int statusCode) {
        this.header("Location", location);
        this.status(statusCode);
        if (this.mode != Mode.EXCHANGE) {
            throw new RedirectException("Redirect");
        }
        this.performRedirect();
    }

    @Override
    public Context removeCookie(String name) {
        this.header(SET_COOKIE, Context.Cookie.expired(name).path("/").toString());
        return this;
    }

    @Override
    public Context removeCookie(String name, String path) {
        this.header(SET_COOKIE, Context.Cookie.expired(name).path(path).toString());
        return this;
    }

    @Override
    public Context render(String name, Map<String, Object> model) {
        this.mgr.render(this, name, model);
        return this;
    }

    @Override
    public String responseHeader(String key) {
        return this.header(this.exchange.getResponseHeaders(), key);
    }

    @Override
    public boolean responseSent() {
        return this.exchange.getResponseCode() > 1;
    }

    @Override
    public Set<Role> routeRoles() {
        return this.roles;
    }

    @Override
    public String scheme() {
        return this.mgr.scheme();
    }

    void setMode(Mode type) {
        this.mode = type;
    }

    @Override
    public SSLSession sslSession() {
        SSLSession sSLSession;
        HttpExchange httpExchange = this.exchange;
        if (httpExchange instanceof HttpsExchange) {
            HttpsExchange ex = (HttpsExchange)httpExchange;
            sSLSession = ex.getSSLSession();
        } else {
            sSLSession = null;
        }
        return sSLSession;
    }

    @Override
    public int status() {
        return this.statusCode;
    }

    @Override
    public Context status(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    int statusCode() {
        return this.statusCode == 0 ? 200 : this.statusCode;
    }

    @Override
    public void text(String content) {
        this.contentType("text/plain;charset=utf-8");
        this.write(content);
    }

    @Override
    public URI uri() {
        return this.exchange.getRequestURI();
    }

    @Override
    public void write(byte[] bufferBytes, int length) {
        try (OutputStream os = this.exchange.getResponseBody();){
            this.exchange.sendResponseHeaders(this.statusCode(), length == 0 ? -1L : (long)length);
            os.write(bufferBytes, 0, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(InputStream is) {
        try (InputStream inputStream = is;
             OutputStream os = this.outputStream();){
            is.transferTo(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(String content) {
        this.write(content.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public JsonService jsonService() {
        return this.mgr.jsonService();
    }

    @Override
    public void rangedWrite(InputStream inputStream, long totalBytes) {
        this.mgr.writeRange(this, inputStream, totalBytes);
    }
}

