/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.http.sse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantLock;

final class Emitter {
    public static final String COMMENT_PREFIX = ":";
    public static final String NEW_LINE = "\n";
    private final ReentrantLock lock = new ReentrantLock();
    private final OutputStream response;
    private boolean closed = false;

    Emitter(OutputStream outputStream) {
        this.response = outputStream;
    }

    boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emit(String event, InputStream data, String id) {
        try {
            this.lock.lock();
            if (id != null) {
                this.write("id: " + id + NEW_LINE);
            }
            this.write("event: " + event + NEW_LINE);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(data, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.write("data: " + line + NEW_LINE);
                }
            }
            this.write(NEW_LINE);
            this.response.flush();
        }
        catch (IOException ignored) {
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    void emit(String comment) {
        try {
            String[] lines;
            for (String line : lines = comment.split(NEW_LINE)) {
                this.write(": " + line + NEW_LINE);
            }
            this.response.flush();
        }
        catch (IOException ignored) {
            this.closed = true;
        }
    }

    private void write(String value) throws IOException {
        this.response.write(value.getBytes(StandardCharsets.UTF_8));
    }
}

