/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.avaje.jex.spi.JsonService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JacksonJsonService
implements JsonService {
    private final ObjectMapper mapper;
    private final Map<String, JavaType> javaTypes = new ConcurrentHashMap<String, JavaType>();

    public JacksonJsonService() {
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonJsonService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T fromJson(Type type, InputStream is) {
        try {
            JavaType javaType = this.javaType(type);
            return (T)this.mapper.readValue(is, javaType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> T fromJson(Type type, byte[] data) {
        try {
            JavaType javaType = this.javaType(type);
            return (T)this.mapper.readValue(data, javaType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JavaType javaType(Type type) {
        return this.javaTypes.computeIfAbsent(type.getTypeName(), k -> this.mapper.getTypeFactory().constructType(type));
    }

    @Override
    public void toJson(Object bean, OutputStream os) {
        try {
            try (JsonGenerator generator = this.mapper.createGenerator(os);){
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                generator.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
                this.mapper.writeValue(generator, bean);
            }
            os.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String toJsonString(Object bean) {
        try {
            return this.mapper.writeValueAsString(bean);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> void toJsonStream(Iterator<T> iterator, OutputStream os) {
        try (JsonGenerator generator = this.mapper.createGenerator(os);){
            generator.setPrettyPrinter(null);
            while (iterator.hasNext()) {
                this.write(iterator, generator);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> void write(Iterator<T> iterator, JsonGenerator generator) {
        try {
            this.mapper.writeValue(generator, iterator.next());
            generator.writeRaw('\n');
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

