/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.core.JdkContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class BufferedOutStream
extends OutputStream {
    private final long max;
    private final JdkContext context;
    private ByteArrayOutputStream buffer;
    private OutputStream stream;
    private long count;

    BufferedOutStream(JdkContext context, int initial, long max) {
        this.context = context;
        this.max = max;
        this.buffer = new ByteArrayOutputStream(initial);
        if (context.responseHeader("Content-length") != null) {
            this.count = max + 1L;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.stream != null) {
            this.stream.write(b);
        } else {
            if (this.count++ > this.max) {
                this.initialiseChunked();
                this.stream.write(b);
                return;
            }
            this.buffer.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.stream != null) {
            this.stream.write(b, off, len);
        } else {
            this.count += (long)len;
            if (this.count > this.max) {
                this.initialiseChunked();
                this.stream.write(b, off, len);
                return;
            }
            this.buffer.write(b, off, len);
        }
    }

    private void initialiseChunked() throws IOException {
        HttpExchange exchange = this.context.exchange();
        String length = this.context.responseHeader("Content-length");
        exchange.sendResponseHeaders(this.context.statusCode(), length == null ? 0L : Long.parseLong(length));
        this.stream = exchange.getResponseBody();
        this.buffer.writeTo(this.stream);
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        } else {
            this.context.write(this.buffer.toByteArray());
        }
    }
}

