/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.core.json.JsonbOutput;
import io.avaje.jex.http.ContentType;
import io.avaje.jex.http.DCookie;
import io.avaje.jex.http.HttpStatus;
import io.avaje.jex.security.BasicAuthCredentials;
import io.avaje.jex.security.Role;
import io.avaje.jex.spi.JsonService;
import io.avaje.jsonb.JsonType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

public interface Context {
    public <T> T attribute(String var1);

    public Context attribute(String var1, Object var2);

    public BasicAuthCredentials basicAuthCredentials();

    public String body();

    public byte[] bodyAsBytes();

    default public <T> T bodyAsClass(Class<T> beanType) {
        return this.bodyAsType(beanType);
    }

    public InputStream bodyAsInputStream();

    public <T> T bodyAsType(Type var1);

    default public <T> T bodyStreamAsClass(Class<T> beanType) {
        return this.bodyAsType(beanType);
    }

    public <T> T bodyStreamAsType(Type var1);

    public long contentLength();

    default public Context contentLength(long length) {
        return this.header("Content-length", String.valueOf(length));
    }

    public String contentType();

    public Context contentType(String var1);

    default public Context contentType(ContentType contentType) {
        return this.contentType(contentType.contentType());
    }

    public String contextPath();

    public Context cookie(Cookie var1);

    public String cookie(String var1);

    public Context cookie(String var1, String var2);

    public Context cookie(String var1, String var2, int var3);

    public Map<String, String> cookieMap();

    public HttpExchange exchange();

    default public String formParam(String key) {
        return this.formParam(key, null);
    }

    default public String formParam(String key, String defaultValue) {
        List<String> values = this.formParamMap().get(key);
        return values == null || values.isEmpty() ? defaultValue : values.getFirst();
    }

    public Map<String, List<String>> formParamMap();

    default public List<String> formParams(String key) {
        List<String> values = this.formParamMap().get(key);
        return values != null ? values : Collections.emptyList();
    }

    default public String fullUrl() {
        String uri = this.uri().toString();
        return uri.charAt(0) != '/' ? uri : this.scheme() + "://" + this.host() + uri;
    }

    public void rangedWrite(InputStream var1, long var2);

    default public void rangedWrite(InputStream inputStream) {
        try {
            this.rangedWrite(inputStream, inputStream.available());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String header(String var1);

    public List<String> headerValues(String var1);

    public Context header(String var1, List<String> var2);

    public Context header(String var1, String var2);

    public Map<String, String> headerMap();

    public Context headerMap(Map<String, List<String>> var1);

    public Headers requestHeaders();

    public Headers responseHeaders();

    default public Context headers(Map<String, String> headers) {
        headers.forEach(this::header);
        return this;
    }

    public String host();

    public void html(String var1);

    public String ip();

    public void json(Object var1);

    default public <T> void jsonb(JsonType<T> jsonType, T value) {
        jsonType.toJson(value, JsonbOutput.of(this.contentType(ContentType.APPLICATION_JSON)));
    }

    public <E> void jsonStream(Iterator<E> var1);

    public <E> void jsonStream(Stream<E> var1);

    public JsonService jsonService();

    public String matchedPath();

    public String method();

    public OutputStream outputStream();

    public String path();

    public String pathParam(String var1);

    public Map<String, String> pathParamMap();

    public int port();

    public String protocol();

    public String queryParam(String var1);

    default public String queryParam(String name, String defaultValue) {
        String val = this.queryParam(name);
        return val != null ? val : defaultValue;
    }

    public Map<String, String> queryParamMap();

    public List<String> queryParams(String var1);

    public String queryString();

    public void redirect(String var1);

    public void redirect(String var1, int var2);

    public Context removeCookie(String var1);

    public Context removeCookie(String var1, String var2);

    default public Context render(String name) {
        return this.render(name, Collections.emptyMap());
    }

    public Context render(String var1, Map<String, Object> var2);

    public String responseHeader(String var1);

    public List<String> responseHeaderValues(String var1);

    public boolean responseSent();

    public Set<Role> routeRoles();

    public String scheme();

    public SSLSession sslSession();

    public int status();

    public Context status(int var1);

    default public Context status(HttpStatus statusCode) {
        return this.status(statusCode.status());
    }

    public void text(String var1);

    public URI uri();

    default public String userAgent() {
        return this.header("User-agent");
    }

    default public void write(byte[] bytes) {
        this.write(bytes, bytes.length);
    }

    public void write(byte[] var1, int var2);

    public void write(InputStream var1);

    public void write(String var1);

    public static interface Cookie {
        public static Cookie expired(String name) {
            return DCookie.expired(name);
        }

        public static Cookie of(String name, String value) {
            return DCookie.of(name, value);
        }

        public String domain();

        public Cookie domain(String var1);

        public ZonedDateTime expires();

        public Cookie expires(ZonedDateTime var1);

        public boolean httpOnly();

        public Cookie httpOnly(boolean var1);

        public Duration maxAge();

        public Cookie maxAge(Duration var1);

        public String name();

        public boolean partitioned();

        public Cookie partitioned(boolean var1);

        public String path();

        public Cookie path(String var1);

        public SameSite sameSite();

        public Cookie sameSite(SameSite var1);

        public boolean secure();

        public Cookie secure(boolean var1);

        public String toString();

        public String value();

        public static enum SameSite {
            Strict,
            Lax,
            None;

        }
    }
}

