/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core.json;

import io.avaje.jex.http.Context;
import io.avaje.json.stream.JsonOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class JsonbOutput
implements JsonOutput {
    private final Context context;
    private OutputStream os;

    public static JsonOutput of(Context context) {
        return new JsonbOutput(context);
    }

    private JsonbOutput(Context context) {
        this.context = context;
    }

    public void write(byte[] content, int offset, int length) throws IOException {
        if (this.os == null) {
            this.os = this.context.outputStream();
        }
        this.os.write(content, offset, length);
    }

    public void writeLast(byte[] content, int offset, int length) throws IOException {
        if (this.os == null) {
            this.context.write(content, length);
        } else {
            this.os.write(content, offset, length);
        }
    }

    public void flush() {
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
    }

    public OutputStream unwrapOutputStream() {
        return this.context.outputStream();
    }
}

