/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core;

import io.avaje.jex.http.Context;
import io.avaje.jex.http.HttpStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;

final class RangeWriter {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    RangeWriter() {
    }

    static void write(Context ctx, InputStream inputStream, long totalBytes, long chunkSize) {
        ctx.header("Accept-ranges", "bytes");
        String rangeHeader = ctx.header("Range");
        if (rangeHeader == null) {
            ctx.contentLength(totalBytes).write(inputStream);
            return;
        }
        List<String> requestedRange = Arrays.stream(rangeHeader.split("=")[1].split("-")).filter(s -> !s.isEmpty()).toList();
        long from = Long.parseLong(requestedRange.get(0));
        boolean audioOrVideo = RangeWriter.isAudioOrVideo(ctx.responseHeader("Content-type"));
        long to = !audioOrVideo || from + chunkSize > totalBytes ? totalBytes - 1L : (requestedRange.size() == 2 ? Long.parseLong(requestedRange.get(1)) : from + chunkSize - 1L);
        long contentLength = audioOrVideo ? Math.min(to - from + 1L, totalBytes) : totalBytes - from;
        HttpStatus status = audioOrVideo ? HttpStatus.PARTIAL_CONTENT_206 : HttpStatus.OK_200;
        ctx.status(status);
        ctx.header("Accept-ranges", "bytes");
        ctx.header("Content-range", "bytes " + from + "-" + to + "/" + totalBytes);
        ctx.contentLength(contentLength);
        try (OutputStream os = ctx.outputStream();){
            RangeWriter.write(os, inputStream, from, to);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void write(OutputStream outputStream, InputStream inputStream, long from, long to) throws IOException {
        int read;
        byte[] buffer = new byte[16384];
        for (long toSkip = from; toSkip > 0L; toSkip -= inputStream.skip(toSkip)) {
        }
        for (long bytesLeft = to - from + 1L; bytesLeft > 0L && (read = inputStream.read(buffer, 0, (int)Math.min(16384L, bytesLeft))) != -1; bytesLeft -= (long)read) {
            outputStream.write(buffer, 0, read);
        }
    }

    private static boolean isAudioOrVideo(String contentType) {
        return contentType.startsWith("audio/") || contentType.startsWith("video/");
    }
}

