/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.spi.HttpServerProvider;
import io.avaje.jex.JexConfig;
import io.avaje.jex.compression.CompressionConfig;
import io.avaje.jex.spi.JsonService;
import io.avaje.jex.spi.TemplateRender;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

final class DJexConfig
implements JexConfig {
    private int port = 8080;
    private String contextPath = "/";
    private String host;
    private int socketBacklog = 0;
    private boolean health = true;
    private boolean ignoreTrailingSlashes = true;
    private Executor executor;
    private JsonService jsonService;
    private final Map<String, TemplateRender> renderers = new HashMap<String, TemplateRender>();
    private HttpsConfigurator httpsConfig;
    private final CompressionConfig compression = new CompressionConfig();
    private int bufferInitial = 256;
    private long bufferMax = 4096L;
    private HttpServerProvider serverProvider;

    DJexConfig() {
    }

    @Override
    public JexConfig host(String host) {
        this.host = host;
        return this;
    }

    @Override
    public JexConfig port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public JexConfig contextPath(String contextPath) {
        if (!this.contextPath.equals(contextPath)) {
            this.contextPath = contextPath.transform(s -> s.charAt(0) == '/' ? s : "/" + s).transform(s -> s.endsWith("/") ? s.substring(0, s.lastIndexOf("/")) : s);
        }
        return this;
    }

    @Override
    public JexConfig socketBacklog(int socketBacklog) {
        this.socketBacklog = socketBacklog;
        return this;
    }

    @Override
    public JexConfig health(boolean health) {
        this.health = health;
        return this;
    }

    @Override
    public JexConfig ignoreTrailingSlashes(boolean ignoreTrailingSlashes) {
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        return this;
    }

    @Override
    public JexConfig jsonService(JsonService jsonService) {
        this.jsonService = jsonService;
        return this;
    }

    @Override
    public JexConfig renderer(String extension, TemplateRender renderer) {
        this.renderers.put(extension, renderer);
        return this;
    }

    @Override
    public Executor executor() {
        if (this.executor == null) {
            this.executor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("avaje-jex-http-", 0L).factory());
        }
        return this.executor;
    }

    @Override
    public JexConfig executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String contextPath() {
        return this.contextPath;
    }

    @Override
    public int socketBacklog() {
        return this.socketBacklog;
    }

    @Override
    public boolean health() {
        return this.health;
    }

    @Override
    public boolean ignoreTrailingSlashes() {
        return this.ignoreTrailingSlashes;
    }

    @Override
    public JsonService jsonService() {
        return this.jsonService;
    }

    @Override
    public Map<String, TemplateRender> renderers() {
        return this.renderers;
    }

    @Override
    public String scheme() {
        return this.httpsConfig == null ? "http" : "https";
    }

    @Override
    public HttpsConfigurator httpsConfig() {
        return this.httpsConfig;
    }

    @Override
    public JexConfig httpsConfig(HttpsConfigurator httpsConfig) {
        this.httpsConfig = httpsConfig;
        return this;
    }

    @Override
    public JexConfig compression(Consumer<CompressionConfig> consumer) {
        consumer.accept(this.compression);
        return this;
    }

    @Override
    public CompressionConfig compression() {
        return this.compression;
    }

    @Override
    public long maxStreamBufferSize() {
        return this.bufferMax;
    }

    @Override
    public int initialStreamBufferSize() {
        return this.bufferInitial;
    }

    @Override
    public JexConfig initialStreamBufferSize(int initialSize) {
        this.bufferInitial = initialSize;
        return this;
    }

    @Override
    public JexConfig maxStreamBufferSize(long maxSize) {
        this.bufferMax = maxSize;
        return this;
    }

    @Override
    public HttpServerProvider serverProvider() {
        return this.serverProvider != null ? this.serverProvider : HttpServerProvider.provider();
    }

    @Override
    public JexConfig serverProvider(HttpServerProvider serverProvider) {
        this.serverProvider = serverProvider;
        return this;
    }
}

