/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.routes;

import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.routes.RouteIndex;
import io.avaje.jex.routes.SpiRoutes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class RouteIndexBuild {
    private final Entry[] entries = new Entry[6];
    private final List<SpiRoutes.Entry> wildcardEntries = new ArrayList<SpiRoutes.Entry>();

    RouteIndexBuild() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new Entry();
        }
    }

    private int index(int segmentCount) {
        return Math.min(segmentCount, 5);
    }

    void add(SpiRoutes.Entry entry) {
        if (entry.multiSlash()) {
            this.wildcardEntries.add(entry);
        } else {
            this.entries[this.index(entry.segmentCount())].add(entry);
        }
    }

    RouteIndex build() {
        ArrayList<List<SpiRoutes.Entry>> pathEntries = new ArrayList<List<SpiRoutes.Entry>>();
        for (Entry entry : this.entries) {
            pathEntries.add(entry.build());
        }
        return new RouteIndex(this.wildcardEntries, pathEntries);
    }

    private static class Entry {
        private final List<SpiRoutes.Entry> list = new ArrayList<SpiRoutes.Entry>();
        private final Map<String, List<SpiRoutes.Entry>> pathMap = new LinkedHashMap<String, List<SpiRoutes.Entry>>();

        private Entry() {
        }

        void add(SpiRoutes.Entry entry) {
            if (entry.literal()) {
                this.list.addFirst(entry);
            } else {
                this.pathMap.computeIfAbsent(entry.matchPath(), k -> new ArrayList(2)).add(entry);
            }
        }

        List<SpiRoutes.Entry> build() {
            ArrayList<SpiRoutes.Entry> result = new ArrayList<SpiRoutes.Entry>(this.list.size() + this.pathMap.size());
            result.addAll(this.list);
            this.pathMap.values().forEach(pathList -> {
                if (pathList.size() == 1) {
                    result.add((SpiRoutes.Entry)pathList.getFirst());
                } else {
                    ExchangeHandler[] handlers = pathList.stream().map(SpiRoutes.Entry::handler).toList().toArray(new ExchangeHandler[0]);
                    result.add(((SpiRoutes.Entry)pathList.getFirst()).multiHandler(handlers));
                }
            });
            return result;
        }
    }
}

