/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.avaje.jex.spi.JsonService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;

public final class JacksonJsonService
implements JsonService {
    private final ObjectMapper mapper;

    public JacksonJsonService() {
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonJsonService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T jsonRead(Class<T> clazz, InputStream is) {
        try {
            return (T)this.mapper.readValue(is, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void jsonWrite(Object bean, OutputStream os) {
        try {
            try (JsonGenerator generator = this.mapper.createGenerator(os);){
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                generator.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
                generator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
                this.mapper.writeValue(generator, bean);
                generator.flush();
            }
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void jsonWriteStream(Iterator<T> iterator, OutputStream os) {
        try {
            JsonGenerator generator = this.mapper.createGenerator(os);
            generator.setPrettyPrinter(null);
            try {
                while (iterator.hasNext()) {
                    this.write(iterator, generator);
                }
            }
            finally {
                generator.flush();
                generator.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> void write(Iterator<T> iterator, JsonGenerator generator) {
        try {
            this.mapper.writeValue(generator, iterator.next());
            generator.writeRaw('\n');
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

