/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import com.sun.net.httpserver.HttpExchange;
import io.avaje.jex.AbstractStaticHandler;
import io.avaje.jex.Context;
import io.avaje.jex.ExchangeHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;

final class StaticFileHandler
extends AbstractStaticHandler
implements ExchangeHandler {
    private final File indexFile;
    private final File singleFile;

    StaticFileHandler(String urlPrefix, String filesystemRoot, Map<String, String> mimeTypes, Map<String, String> headers, Predicate<Context> skipFilePredicate, File welcomeFile, File singleFile) {
        super(urlPrefix, filesystemRoot, mimeTypes, headers, skipFilePredicate);
        this.indexFile = welcomeFile;
        this.singleFile = singleFile;
    }

    @Override
    public void handle(Context ctx) throws IOException {
        File canonicalFile;
        String wholeUrlPath;
        HttpExchange jdkExchange = ctx.exchange();
        if (this.singleFile != null) {
            this.sendFile(ctx, jdkExchange, this.singleFile.getPath(), this.singleFile);
            return;
        }
        if (this.skipFilePredicate.test(ctx)) {
            this.throw404(jdkExchange);
        }
        if ((wholeUrlPath = jdkExchange.getRequestURI().getPath()).endsWith("/") || wholeUrlPath.equals(this.urlPrefix)) {
            this.sendFile(ctx, jdkExchange, this.indexFile.getPath(), this.indexFile);
            return;
        }
        String urlPath = wholeUrlPath.substring(this.urlPrefix.length());
        try {
            canonicalFile = new File(this.filesystemRoot, urlPath).getCanonicalFile();
        }
        catch (IOException e) {
            this.reportPathTraversal();
            return;
        }
        String canonicalPath = canonicalFile.getPath();
        if (!canonicalPath.startsWith(this.filesystemRoot)) {
            this.reportPathTraversal();
        }
        this.sendFile(ctx, jdkExchange, urlPath, canonicalFile);
    }

    private void sendFile(Context ctx, HttpExchange jdkExchange, String urlPath, File canonicalFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(canonicalFile);){
            String mimeType = this.lookupMime(urlPath);
            ctx.header("Content-Type", mimeType);
            ctx.headers(this.headers);
            ctx.write(fis);
        }
        catch (FileNotFoundException e) {
            this.throw404(jdkExchange);
        }
    }
}

