/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex;

import io.avaje.jex.ExceptionHandler;
import io.avaje.jex.ExchangeHandler;
import io.avaje.jex.HttpFilter;
import io.avaje.jex.Routing;
import io.avaje.jex.security.Role;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DefaultRouting
implements Routing {
    private final List<Routing.Entry> handlers = new ArrayList<Routing.Entry>();
    private final List<HttpFilter> filters = new ArrayList<HttpFilter>();
    private final Deque<String> pathDeque = new ArrayDeque<String>();
    private final Map<Class<?>, ExceptionHandler<?>> exceptionHandlers = new HashMap();
    private Entry lastEntry;

    DefaultRouting() {
    }

    @Override
    public List<Routing.Entry> handlers() {
        return this.handlers;
    }

    @Override
    public List<HttpFilter> filters() {
        return this.filters;
    }

    @Override
    public Map<Class<?>, ExceptionHandler<?>> errorHandlers() {
        return this.exceptionHandlers;
    }

    private String path(String path) {
        return String.join((CharSequence)"", this.pathDeque) + (String)(path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    private void addEndpoints(String path, Routing.Group group) {
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        this.pathDeque.addLast((String)path);
        group.addGroup();
        this.pathDeque.removeLast();
    }

    @Override
    public Routing add(Routing.HttpService routes) {
        routes.add(this);
        return this;
    }

    @Override
    public Routing addAll(Collection<Routing.HttpService> routes) {
        for (Routing.HttpService route : routes) {
            route.add(this);
        }
        return this;
    }

    @Override
    public <T extends Exception> Routing error(Class<T> type, ExceptionHandler<T> handler) {
        this.exceptionHandlers.put(type, handler);
        return this;
    }

    @Override
    public Routing path(String path, Routing.Group group) {
        this.addEndpoints(path, group);
        return this;
    }

    @Override
    public Routing withRoles(Set<Role> permittedRoles) {
        if (this.lastEntry == null) {
            throw new IllegalStateException("Must call withRoles() after adding a route");
        }
        this.lastEntry.withRoles(permittedRoles);
        return this;
    }

    @Override
    public Routing withRoles(Role ... permittedRoles) {
        return this.withRoles(Set.of(permittedRoles));
    }

    private void add(Routing.Type verb, String path, ExchangeHandler handler) {
        this.lastEntry = new Entry(verb, this.path(path), handler);
        this.handlers.add(this.lastEntry);
    }

    @Override
    public Routing get(String path, ExchangeHandler handler) {
        this.add(Routing.Type.GET, path, handler);
        return this;
    }

    @Override
    public Routing post(String path, ExchangeHandler handler) {
        this.add(Routing.Type.POST, path, handler);
        return this;
    }

    @Override
    public Routing put(String path, ExchangeHandler handler) {
        this.add(Routing.Type.PUT, path, handler);
        return this;
    }

    @Override
    public Routing patch(String path, ExchangeHandler handler) {
        this.add(Routing.Type.PATCH, path, handler);
        return this;
    }

    @Override
    public Routing delete(String path, ExchangeHandler handler) {
        this.add(Routing.Type.DELETE, path, handler);
        return this;
    }

    @Override
    public Routing head(String path, ExchangeHandler handler) {
        this.add(Routing.Type.HEAD, path, handler);
        return this;
    }

    @Override
    public Routing trace(String path, ExchangeHandler handler) {
        this.add(Routing.Type.TRACE, path, handler);
        return this;
    }

    @Override
    public Routing options(String path, ExchangeHandler handler) {
        this.add(Routing.Type.OPTIONS, path, handler);
        return this;
    }

    @Override
    public Routing filter(HttpFilter handler) {
        this.filters.add(handler);
        return this;
    }

    private static final class Entry
    implements Routing.Entry {
        private final Routing.Type type;
        private final String path;
        private final ExchangeHandler handler;
        private Set<Role> roles = Collections.emptySet();

        Entry(Routing.Type type, String path, ExchangeHandler handler) {
            this.type = type;
            this.path = path;
            this.handler = handler;
        }

        void withRoles(Set<Role> roles) {
            this.roles = roles;
        }

        @Override
        public Routing.Type getType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public ExchangeHandler getHandler() {
            return this.handler;
        }

        @Override
        public Set<Role> getRoles() {
            return this.roles;
        }
    }
}

